package hu.bme.dszenasi.circleandroid.login.module;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.core.util.SelfSigningClientBuilder;
import hu.bme.dszenasi.circleandroid.login.repository.ILoginRepository;
import hu.bme.dszenasi.circleandroid.login.repository.LoginRepository;
import hu.bme.dszenasi.circleandroid.login.ui.LoginPresenter;
import hu.bme.dszenasi.circleandroid.login.ui.LoginPresenterImpl;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;


/**
 * Created by mszenasi on 2016-04-26.
 */
@Module
public class LoginModule {

    String mBaseUrl;

    public LoginModule(String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    @Provides
    @Singleton
    public ILoginRepository providesLoginRepository(Retrofit retrofit) {
        return new LoginRepository(retrofit);
    }

    @Provides
    @Singleton
    public LoginPresenter providesLoginPresenter(ILoginRepository loginRepository, ErrorUtil errorUtil) {
        return new LoginPresenterImpl(loginRepository, errorUtil);
    }

    @Provides
    @Singleton
    SharedPreferences providesSharedPreferences(Application application) {
        return PreferenceManager.getDefaultSharedPreferences(application);
    }

    @Provides
    @Singleton
    OkHttpClient provideOkHttpClient(Application application) {
        return SelfSigningClientBuilder.createClient(application);

    }

    @Provides
    @Singleton
    ErrorUtil provideErrorUtil(Retrofit retrofit) {
        return new ErrorUtil(retrofit);

    }

    //gson
    @Provides
    @Singleton
    Retrofit provideRetrofit(OkHttpClient okHttpClient) {
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(mBaseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();
        return retrofit;
    }

}
