package hu.bme.dszenasi.circleandroid.createvm.ui;

import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.createvm.repository.CreateVmRepository;
import hu.bme.dszenasi.circleandroid.occicore.CreateVmData;
import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import hu.bme.dszenasi.circleandroid.occicore.Resource;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by mszenasi on 2016-04-28.
 */
public class CreateVmPresenterImpl implements CreateVmPresenter{

    CreateVmRepository createVmRepository;
    CreateVmView createVmView;
    ErrorUtil errorUtil;

    public CreateVmPresenterImpl(CreateVmRepository createVmRepository, ErrorUtil errorUtil) {
        this.createVmRepository = createVmRepository;
        this.errorUtil = errorUtil;
    }

    @Override
    public void setView(CreateVmView createVmView) {
        this.createVmView = createVmView;
    }

    @Override
    public void destroyView() {
        createVmView = null;
    }

    @Override
    public void createVm(CreateVmData createVmData, int vmId) {
        Callback<Resource> callback = new Callback<Resource>() {

            @Override
            public void onResponse(Call<Resource> call, Response<Resource> response) {
                if (response.isSuccessful()) {
                    createVmView.showSuccess();
                } else {
                    OCCILoginResponse occiLoginResponse = errorUtil.parseError(response);
                    //loginView.showLoginError(occiLoginResponse.getErrors());
                }
            }

            @Override
            public void onFailure(Call<Resource> call, Throwable t) {
                // handle execution failures like no internet connectivity
            }
        };
        createVmRepository.vmCreatVm(callback, createVmData, vmId);
    }
}
