package hu.bme.dszenasi.circleandroid.createvm.ui;

import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import hu.bme.dszenasi.circleandroid.MyApplication;
import hu.bme.dszenasi.circleandroid.R;
import hu.bme.dszenasi.circleandroid.occicore.CreateVmData;

/**
 * Created by mszenasi on 2016-04-28.
 */
public class CreateVmActivity extends AppCompatActivity implements CreateVmView{

    @Inject
    CreateVmPresenter createVmPresenter;
    Button createVmButton;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.createvm_activity);
        injectDependencies();
        createVmPresenter.setView(this);
        createVmButton = (Button) findViewById(R.id.createvmbutton);
        createVmButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                List<String> mixins = new ArrayList<>();
                mixins.add("http://circlecloud.org/occi/templates/os#os_template_1");
                CreateVmData createVmData = new CreateVmData(mixins, "may be provided");
                createVmPresenter.createVm(createVmData, 1);
            }
        });
    }

    @Override
    public void onCreate(Bundle savedInstanceState, PersistableBundle persistentState) {
        super.onCreate(savedInstanceState, persistentState);
    }

    @Override
    protected void onDestroy() {
        createVmPresenter.destroyView();
        super.onDestroy();
    }


    protected void injectDependencies() {
        ((MyApplication) getApplication()).getCreateVmComponent().inject(this);
    }

    @Override
    public void showSuccess() {

    }
}
