package hu.bme.dszenasi.circleandroid.createvm.module;

import android.app.Application;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.core.util.SelfSigningClientBuilder;
import hu.bme.dszenasi.circleandroid.createvm.repository.CreateVmRepository;
import hu.bme.dszenasi.circleandroid.createvm.repository.ICreateVmRepository;
import hu.bme.dszenasi.circleandroid.createvm.ui.CreateVmPresenter;
import hu.bme.dszenasi.circleandroid.createvm.ui.CreateVmPresenterImpl;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by mszenasi on 2016-04-28.
 */
@Module
public class CreateVmModule {

    String mBaseUrl;

    public CreateVmModule(String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    @Provides
    @Singleton
    public CreateVmRepository providesCreateVmRepository(Retrofit retrofit) {
        return new CreateVmRepository(retrofit);
    }

    @Provides
    @Singleton
    public CreateVmPresenter providesCreateVmPresenter(CreateVmRepository createVmRepository, ErrorUtil errorUtil) {
        return new CreateVmPresenterImpl(createVmRepository, errorUtil);
    }

    @Provides
    @Singleton
    SharedPreferences providesSharedPreferences(Application application) {
        return PreferenceManager.getDefaultSharedPreferences(application);
    }

    @Provides
    @Singleton
    OkHttpClient provideOkHttpClient(Application application) {
        return SelfSigningClientBuilder.createClient(application);

    }

    @Provides
    @Singleton
    ErrorUtil provideErrorUtil(Retrofit retrofit) {
        return new ErrorUtil(retrofit);

    }

    //gson
    @Provides
    @Singleton
    Retrofit provideRetrofit(OkHttpClient okHttpClient) {
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(mBaseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();
        return retrofit;
    }

}