package hu.bme.dszenasi.circleandroid.core.util;

/**
 * Created by danielszenasi on 05/05/16.
 */

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;


import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

import hu.bme.dszenasi.circleandroid.R;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Interceptor;
import okhttp3.Response;


public class SelfSigningClientBuilder {
    public static OkHttpClient createClient(Application application) {

        final TrustManager[] certs = new TrustManager[]{new X509TrustManager() {

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(final X509Certificate[] chain,
                                           final String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(final X509Certificate[] chain,
                                           final String authType) throws CertificateException {
            }
        }};

        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, certs, new SecureRandom());

        } catch (final java.security.GeneralSecurityException ex) {
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory(ctx.getSocketFactory());
        builder.hostnameVerifier(new HostnameVerifier() {
            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        //JavaNetCookieJar jncj = new JavaNetCookieJar(CookieHandler.getDefault());
        //httpClient.cookieJar(jncj);
        builder.addInterceptor(new AddCookiesInterceptor(application));
        builder.addInterceptor(new ReceivedCookiesInterceptor(application));
        return builder.build();


    }

}
