package hu.bme.dszenasi.circleandroid.core.util;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import android.util.Log;

import java.io.IOException;
import java.util.HashSet;
import java.util.prefs.Preferences;


import okhttp3.Interceptor;
import okhttp3.Response;

/**
 * Created by danielszenasi on 09/05/16.
 */
public class ReceivedCookiesInterceptor implements Interceptor {
    public static final String PREF_COOKIES = "PREF_COOKIES";
    private Application application;

    public ReceivedCookiesInterceptor(Application application) {
        this.application = application;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Response originalResponse = chain.proceed(chain.request());
        if (!originalResponse.headers("Set-Cookie").isEmpty()) {
            HashSet<String> cookies = new HashSet<>();
            for (String cookie : originalResponse.headers("Set-Cookie")) {
                for (String possibleSessionCookie : cookie.split(";")) {
                    if (possibleSessionCookie.startsWith("csessidc3c8") && cookie.contains("=")) {
                        String csessidc3c8 = possibleSessionCookie.split("=")[1];
                        PreferenceManager.getDefaultSharedPreferences(application).edit()
                                .putString("csessidc3c8",csessidc3c8)
                                .apply();
                    }
                    if (possibleSessionCookie.startsWith("csrftoken") && cookie.contains("=")) {
                        String csrftoken = possibleSessionCookie.split("=")[1];
                        PreferenceManager.getDefaultSharedPreferences(application).edit()
                                .putString("csrftoken",csrftoken)
                                .apply();
                    }

                }
            }
        }
        return originalResponse;
    }
}
