package hu.bme.dszenasi.circleandroid.core.util;

import java.io.IOException;
import java.lang.annotation.Annotation;

import javax.inject.Inject;

import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

/**
 * Created by danielszenasi on 09/05/16.
 */
public class ErrorUtil {
    private Retrofit retrofit;

    public ErrorUtil(Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    public OCCILoginResponse parseError(Response<?> response) {
        Converter<ResponseBody, OCCILoginResponse> converter =
                retrofit.responseBodyConverter(OCCILoginResponse.class, new Annotation[0]);
        OCCILoginResponse error;
        try {
            error = converter.convert(response.errorBody());
        } catch (IOException e) {
            return new OCCILoginResponse();
        }

        return error;
    }
}
