package hu.bme.dszenasi.circleandroid.core.util;


import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import android.util.Log;

import java.io.IOException;
import java.util.HashSet;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * This interceptor put all the Cookies in Preferences in the Request.
 * Your implementation on how to get the Preferences MAY VARY.
 */
public class AddCookiesInterceptor implements Interceptor {
    public static final String PREF_COOKIES = "PREF_COOKIES";
    private Application application;

    public AddCookiesInterceptor(Application application) {
        this.application = application;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        String csessidc3c8 = PreferenceManager.getDefaultSharedPreferences(application).getString("csessidc3c8","csessidc3c8isnull");
        String csrftoken = PreferenceManager.getDefaultSharedPreferences(application).getString("csrftoken", "csrftokenisnull");
        builder.addHeader("Referer", "https://vm.ik.bme.hu:1415/");

        if(csrftoken != "csrftokenisnull") {
            builder.addHeader("X-CSRFToken", csrftoken);
        }

        if (csessidc3c8 != "csessidc3c8isnull" && csrftoken != "csrftokenisnull") {
            builder.addHeader("Cookie", "csrftoken=" + csrftoken + ";" + "csessidc3c8=" + csessidc3c8);
        }

        return chain.proceed(builder.build());
    }
}