package hu.bme.dszenasi.circleandroid.core.api;


import hu.bme.dszenasi.circleandroid.occicore.Action;
import hu.bme.dszenasi.circleandroid.occicore.ActionWithAttributes;
import hu.bme.dszenasi.circleandroid.occicore.CreateVmData;
import hu.bme.dszenasi.circleandroid.occicore.LoginData;
import hu.bme.dszenasi.circleandroid.occicore.OCCIComputeResponse;
import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import hu.bme.dszenasi.circleandroid.occicore.Resource;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

/**
 * Created by danielszenasi on 03/05/16.
 */
public interface OCCICircleApi {
    @GET("/occi/login/")
    Call<OCCILoginResponse> loginGet();

    @POST("/occi/login/")
    Call<OCCILoginResponse> loginPost(@Body LoginData loginData);

    @GET("/occi/compute/")
    Call<OCCIComputeResponse> allCompute();

    @GET("/occi/-/")
    Call<OCCILoginResponse> queryInterface();

    @DELETE("/occi/compute/{vmid}/")
    Call<Resource> deleteCompute(@Path("vmid") int vmid);

    @POST("/occi/compute/{vmid}/")
    Call<Resource> startCompute(@Path("vmid") int vmid, @Body Action action);

    @POST("/occi/compute/{vmid}/")
    Call<Resource> startCompute(@Path("vmid") int vmid, @Body ActionWithAttributes action);

    @PUT("/occi/compute/{vmid}/")
    Call<Resource> createCompute(@Path("vmid") int vmid, @Body CreateVmData data);

}
