package hu.bme.dszenasi.circleandroid;

import android.app.Application;

import hu.bme.dszenasi.circleandroid.createvm.module.CreateVmComponent;
import hu.bme.dszenasi.circleandroid.createvm.module.CreateVmModule;
import hu.bme.dszenasi.circleandroid.createvm.module.DaggerCreateVmComponent;
import hu.bme.dszenasi.circleandroid.login.module.DaggerLoginComponent;
import hu.bme.dszenasi.circleandroid.login.module.LoginComponent;
import hu.bme.dszenasi.circleandroid.login.module.LoginModule;
import hu.bme.dszenasi.circleandroid.managevm.module.DaggerManageVmComponent;
import hu.bme.dszenasi.circleandroid.managevm.module.ManageVmComponent;
import hu.bme.dszenasi.circleandroid.managevm.module.ManageVmModule;
import hu.bme.dszenasi.circleandroid.vmlist.module.DaggerVmListComponent;
import hu.bme.dszenasi.circleandroid.vmlist.module.VmListComponent;
import hu.bme.dszenasi.circleandroid.vmlist.module.VmListModule;

/**
 * Created by mszenasi on 2016-04-26.
 */
public class MyApplication extends Application {
    LoginComponent logincomponent;
    VmListComponent vmListComponent;
    ManageVmComponent manageVmComponent;
    CreateVmComponent createVmComponent;

    @Override
    public void onCreate() {
        super.onCreate();
        logincomponent = DaggerLoginComponent.builder()
                .appModule(new AppModule(this))
                .loginModule(new LoginModule("https://vm.ik.bme.hu:1415/"))
                .build();
        vmListComponent = DaggerVmListComponent.builder()
                .appModule(new AppModule(this))
                .vmListModule(new VmListModule("https://vm.ik.bme.hu:1415/"))
                .build();
        manageVmComponent = DaggerManageVmComponent.builder()
                .appModule(new AppModule(this))
                .manageVmModule(new ManageVmModule("https://vm.ik.bme.hu:1415/"))
                .build();
        createVmComponent = DaggerCreateVmComponent.builder()
                .appModule(new AppModule(this))
                .createVmModule(new CreateVmModule("https://vm.ik.bme.hu:1415/"))
                .build();
    }

    public LoginComponent getloginComponent() {
        return logincomponent;
    }
    public ManageVmComponent getManageVmComponent() {
        return manageVmComponent;
    }
    public CreateVmComponent getCreateVmComponent() {
        return createVmComponent;
    }
    public VmListComponent getVmListComponent() {
        return vmListComponent;
    }
}