// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#ifndef OCCILIB_TEMPLATE_H_
#define OCCILIB_TEMPLATE_H_

#include <string>
#include <vector>
#include <memory>
#include "json.hpp"
#include "occisession.h"

namespace OcciClient{

    class Template {
        private:
            std::string defaultArchitecture;
            double defaultMemory;
            int defaultCores;
            int defaultCpuShare;
            std::string title;
            std::string scheme;
            std::string term;


        public:
            Template(nlohmann::json);
            static std::vector< std::shared_ptr<Template> > getTemplates(OcciSession*);
            std::string getDefaultArchitecture();
            double getDefaultMemory();
            int getDefaultCores();
            int getDefaultCpuShare();
            std::string getTemplateIdentifier();
            std::string getTitle();
    };

}

#endif // OCCILIB_TEMPLATE_H
