// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#include <string>
#include <vector>
#include <memory>
#include "occisession.h"
#include "json.hpp"
#include "template.h"

//TODO remove this include
#include <iostream>

using nlohmann::json;
using std::string;
using std::vector;
using std::shared_ptr;
using std::make_shared;

namespace OcciClient{

    vector< shared_ptr<Template> > Template::getTemplates(OcciSession* session){
        json mixins = session->queryInterface()["mixins"];
        auto result = vector< shared_ptr<Template> >();
        for (auto& mixin : mixins) {
            if (mixin["depends"] == "http://schemas.ogf.org/occi/infrastructure#os_tpl") {
                auto tpl = make_shared<Template>(mixin);
                result.push_back(tpl);
            }
        }
        return result;
    }

    Template::Template(json rendering) {
        this->scheme = rendering["scheme"].get<string>();
        this->term = rendering["term"].get<string>();
        this->title = rendering["title"].get<string>();
        this->defaultCores = rendering["attributes"]["occi.compute.cores"]["default"].get<int>();
        this->defaultCpuShare = rendering["attributes"]["occi.compute.share"]["default"].get<int>();
        this->defaultMemory = rendering["attributes"]["occi.compute.memory"]["default"].get<double>();
        this->defaultArchitecture = rendering["attributes"]["occi.compute.architecture"]["default"].get<string>();
    }

    string Template::getTemplateIdentifier() {
        return this->scheme + this->term;
    }

    std::string Template::getDefaultArchitecture() {
        return this->defaultArchitecture;
    }

    double Template::getDefaultMemory() {
        return this->defaultMemory;
    }

    int Template::getDefaultCores() {
        return this->defaultCores;
    }

    int Template::getDefaultCpuShare() {
        return this->defaultCpuShare;
    }

    string Template::getTitle(){
        return this->title;
    }

}
