// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#include <string>
#include <memory>
#include "json.hpp"
#include "resource.h"

#include "storage.h"

using std::string;
using nlohmann::json;
using std::shared_ptr;
using std::make_shared;
using namespace OcciClient;

void Storage::parseJsonInstance(json instance) {
    Resource::parseJsonInstance(instance);
    this->state = getAttributeFromRendering<string>(instance, "occi.storage.state");
    this->stateMessage = getAttributeFromRendering<string>(instance, "occi.storage.state.message");
    this->size = getAttributeFromRendering<double>(instance, "occi.storage.size");
    this->rendering = instance;
}

Storage::Storage(OcciSession* session, json instance)
    : Resource(session, "storage", instance) {
    parseJsonInstance(instance);
}

void Storage::invokeAction(json actionData) {
    auto inst = Resource::invokeAction(actionData);
    parseJsonInstance(inst);
}

shared_ptr<Storage> Storage::getStorageInstance(OcciSession* session, string id) {
    auto uri = "storage/" + id + "/";
    auto instance = session->get(uri);
    return make_shared<Storage>(Storage(session, instance));
}

string Storage::getState(){
    return this->state;
}

string Storage::getStateMessage(){
    return this->stateMessage;
}

double Storage::getSize(){
    return this->size;
}
