"""A setuptools based setup module.

See:
https://packaging.python.org/en/latest/distributing.html
https://github.com/pypa/sampleproject
"""

# Always prefer setuptools over distutils
from setuptools import setup, Extension
from setuptools.command.build_ext import build_ext
from subprocess import check_call


_occi = Extension('_occi',
                  sources=['occilib.i'],
                  include_dirs=['restclient-cpp/include'],
                  library_dirs=['.'],
                  swig_opts=['-c++'],
                  extra_compile_args=['-std=c++11', '-Ofast'],
                  libraries=['occi', 'restclient-cpp', 'curl',
                             # for BMElogin method
                             'gq', 'gumbo',
                             # for saml2EcpLogin method
                             'lasso', 'xmlsec1', 'gobject-2.0', 'ffi',
                             'xslt', 'dl', 'xml2', 'z', 'm', 'glib-2.0',
                             ]
                  )


class Build(build_ext):

    def run(self):
        check_call(['make', 'lib'])
        build_ext.run(self)


setup(
    name='libocci',

    # Versions should comply with PEP440.  For a discussion on single-sourcing
    # the version across setup.py and the project code, see
    # https://packaging.python.org/en/latest/single_source_version.html
    version='1.0.0',

    description='OCCI client library for CIRCLE cloud',

    # The project's main homepage.
    url='https://git.ik.bme.hu/circle/libocci',

    # Author details
    author='BME IK',
    author_email='cloud@ik.bme.hu',

    # Choose your license
    license='GPLv3',

    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 5 - Production/Stable',

        # Indicate who your project is intended for
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        # 'Programming Language :: Python :: 3',
        # 'Programming Language :: Python :: 3.3',
        # 'Programming Language :: Python :: 3.4',
        # 'Programming Language :: Python :: 3.5',
    ],

    # What does your project relate to?
    keywords='libocci occi OCCI CIRCLE cloud',

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    # packages=find_packages(exclude=['contrib', 'docs', 'tests']),

    # Alternatively, if you want to distribute just a my_module.py, uncomment
    # this:
    py_modules=["occi"],
    ext_modules=[_occi],

    cmdclass={'build_ext': Build},
)
