#ifndef SAML2_ECP_H
#define SAML2_ECP_H

#include <restclient-cpp/restclient.h>
#include <stdexcept>

#define MEDIA_TYPE_PAOS "application/vnd.paos+xml"
#define PAOS_HEADER ("ver=\"" LASSO_PAOS_HREF "\";\"" LASSO_ECP_HREF "\"")
#define MEDIA_TYPE_SOAP "application/soap+xml"


namespace OcciClient {

struct HttpError: public std::runtime_error{
    int status_code;
    std::string message;
    
    HttpError(std::string message, int status_code)
        :runtime_error(""),status_code(status_code){
        
        this->message = std::string("Status code: ") +
                        std::to_string(status_code) +
                        " Message: " + message;

    }

    const char* what() const noexcept{
        return message.c_str();
    }
};

RestClient::Response saml2_ecp_login(std::string username,
                                     std::string password,
                                     std::string login_url,
                                     std::string metadata,
                                     bool insecure=false);

}


#endif // SAML2_ECP_H
