// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#ifndef OCCILIB_SESSION_H_
#define OCCILIB_SESSION_H_

#include <string>
#include "restclient-cpp/connection.h"
#include "restclient-cpp/restclient.h"
#include "json.hpp"

namespace OcciClient {


    enum class RequestType{Get, Post, Delete, Put};


    class OcciSession {

    private:

        std::string url;
        RestClient::Connection* connection = nullptr;
        bool csrftokenRequired = false;
        std::string csrfuri;

        void setCsrfTokenHeader();

    public:

        OcciSession(const char* url, bool insecure = false, bool csrf = false);

        ~OcciSession();

        nlohmann::json doRequest(std::string uri, RequestType type, nlohmann::json body = nullptr);

        nlohmann::json get(std::string uri);

        nlohmann::json post(std::string uri, nlohmann::json body = nullptr);

        nlohmann::json put(std::string uri, nlohmann::json body = nullptr);

        nlohmann::json del(std::string uri);

        void circleOcciLogin(std::string username, std::string password);

        void BMELogin(std::string username, std::string password, bool insecure=false);
        void saml2EcpLogin(std::string username,
                           std::string password,
                           std::string metadata,
                           bool insecure=false);

        nlohmann::json queryInterface();
    };
}

#endif // OCCILIB_SESSION_H_
