%module occi
%{
/* Includes the header in the wrapper code */
#include "entity.hpp"
#include "resource.h"
#include "link.h"
#include "compute.h"
#include "template.h"
#include "storage.h"
#include "network.h"
%}



/* Parse the header file to generate wrappers */
%include "std_string.i"
%include "std_vector.i"
%include "std_shared_ptr.i"

%include "occisession.i"

%shared_ptr(OcciClient::Entity)
%shared_ptr(OcciClient::Resource)
%shared_ptr(OcciClient::Link)
%shared_ptr(OcciClient::Compute)
%shared_ptr(OcciClient::Storage)
%shared_ptr(OcciClient::Network)
%shared_ptr(OcciClient::Template)

%include "entity.hpp"
%include "resource.h"
%include "link.h"
%include "template.h"
%include "compute.h"
%include "storage.h"
%include "network.h"

namespace std {
    %template(TemplateVector) vector<shared_ptr<OcciClient::Template>>;
    %template(ComputeInstanceVector) vector<shared_ptr<OcciClient::Compute>>;
}
