// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#include <string>
#include <memory>
#include "json.hpp"
#include "resource.h"

#include "network.h"

using std::string;
using nlohmann::json;
using std::shared_ptr;
using std::make_shared;
using namespace OcciClient;

void Network::parseJsonInstance(json instance) {
    Resource::parseJsonInstance(instance);
    this->state = getAttributeFromRendering<string>(instance, "occi.network.state");
    this->stateMessage = getAttributeFromRendering<string>(instance, "occi.network.state.message");
    this->vlan = getAttributeFromRendering<int>(instance, "occi.network.vlan");
    this->address = getAttributeFromRendering<string>(instance, "occi.network.address");
    this->gateway = getAttributeFromRendering<string>(instance, "occi.network.gateway");
    this->allocation = getAttributeFromRendering<string>(instance, "occi.network.allocation");
    this->rendering = instance;
}

Network::Network(OcciSession* session, json instance)
    : Resource(session, "network", instance) {
    parseJsonInstance(instance);
}

void Network::invokeAction(json actionData) {
    auto inst = Resource::invokeAction(actionData);
    parseJsonInstance(inst);
}

shared_ptr<Network> Network::getNetworkInstance(OcciSession* session, string id) {
    auto uri = "network/" + id + "/";
    auto instance = session->get(uri);
    return make_shared<Network>(Network(session, instance));
}

string Network::getState(){
    return this->state;
}

string Network::getStateMessage(){
    return this->stateMessage;
}

int Network::getVlan(){
    return this->vlan;
}

string Network::getAddress(){
    return this->address;
}

string Network::getGateway(){
    return this->gateway;
}

string Network::getAllocation(){
    return this->allocation;
}
