// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#ifndef OCCILIB_LINK_H
#define OCCILIB_LINK_H

#include <string>
#include "json.hpp"
#include "occisession.h"
#include "entity.hpp"

namespace OcciClient {

    class Link : public Entity {

    private:

        std::string target;
        std::string targetKind;

    protected:

        Link(OcciSession* session, std::string kind, nlohmann::json instance);

    public:

        std::string getTarget();

        std::string getTargetKind();

    };

}

#endif // OCCILIB_LINK_H
