// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#include <string>
#include "json.hpp"
#include "occisession.h"
#include "entity.hpp"
#include "link.h"

using std::string;
using nlohmann::json;
using namespace OcciClient;

Link::Link(OcciSession* session, string kind, json instance)
    : Entity(session, kind, instance){}

string Link::getTarget(){
    return this->target;
}

string Link::getTargetKind(){
    return this->targetKind;
}
