// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#ifndef OCCILIB_ENTITY_H_
#define OCCILIB_ENTITY_H_

#include <string>

#include "json.hpp"
#include "occisession.h"

namespace OcciClient{

    class Entity{
	    protected:

            OcciSession* session;
            std::string id;
            std::string title;
            nlohmann::json rendering;
            std::string kind;

            void parseJsonInstance(nlohmann::json instance);

            std::string getID(nlohmann::json& rendering);

            template <typename T> T getAttributeFromRendering(nlohmann::json& rendering, const std::string which, const T defaultValue = T()) {
                try {
                    return rendering["attributes"][which].get<T>();
                }
                catch (std::exception e){
                    return defaultValue;
                }
            }

            Entity(OcciSession* session, std::string kind, nlohmann::json instance);

        public:

            std::string getId();

            std::string getTitle();

            static nlohmann::json invokeAction(OcciSession* session, std::string kind, std::string id, nlohmann::json actionData);

            nlohmann::json invokeAction(nlohmann::json actionData);

            nlohmann::json getRendering();

            void destroyInstance();
    };
}

#endif // OCCILIB_ENTITY_H_
