// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#include <string>

#include "json.hpp"
#include "occisession.h"

#include "entity.hpp"

using std::string;
using nlohmann::json;
using namespace OcciClient;

void Entity::parseJsonInstance(json instance) {
    this->id = getID(instance);
    if (instance.find("title") != instance.end()) {
        this->title = instance["title"].get<string>();
    }
    this->rendering = instance;
}

Entity::Entity(OcciSession* session, string kind, json instance) {
    this->session = session;
    this->kind = kind;
    parseJsonInstance(instance);
}

string Entity::getID(json& rendering) {
    try {
        return rendering["id"];
    }
    catch (std::domain_error) {
        return "";
    }
}

string Entity::getId(){
    return this->id;
}

string Entity::getTitle(){
    return this->title;
}

json Entity::invokeAction(OcciSession* session, string kind, string id, json actionData) {
    auto uri = kind + "/" + id + "/";
    return session->post(uri, actionData);
}

json Entity::invokeAction(json actionData){
    return invokeAction(this->session, this->kind, this->id, actionData);
}

json Entity::getRendering(){
    return this->rendering;
}

void Entity::destroyInstance() {
    auto uri = this->kind + "/" + this->id + "/";
    session->del(uri);
}
