// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#ifndef OCCILIB_COMPUTE_H_
#define OCCILIB_COMPUTE_H_

#include <string>
#include <vector>
#include <memory>

#include "json.hpp"
#include "resource.h"
#include "template.h"

namespace OcciClient {

    class Compute : public Resource {

        private:

            std::string state;
            std::string stateMessage;
            double memory;
            int cpuShare;
            int cores;
            std::string hostname;
            std::string architecture;
            std::string credentialProtocol;
            int credentialPort;
            std::string credentialHost;
            std::string credentialPassword;
            std::string credentialUsername;
            std::string credentialCommand;
            std::string leasetimeSuspend;
            std::string leasetimeRemove;

            void parseJsonInstance(nlohmann::json instance);

            Compute(OcciSession* session, nlohmann::json instance);

            void invokeAction(nlohmann::json actionData);

        public:

            static std::shared_ptr<Compute> getComputeInstance(OcciSession* session, std::string id);

            static std::shared_ptr<Compute> createComputeInstance(OcciSession* session, Template* t);

            static std::vector<std::shared_ptr<Compute>> getComputeInstances(OcciSession* session);

            static std::vector<std::string> getComputeInstanceIds(OcciSession* session);

            std::string getState();

            std::string getStateMessage();

            double getMemory();

            int getCpuShare();

            int getCores();

            std::string getHostname();

            std::string getArchitecture();

            std::string getCredentialProtocol();

            int getCredentialPort();

            std::string getCredentialHost();

            std::string getCredentialPassword();

            std::string getCredentialUsername();

            std::string getCredentialCommand();

            std::string getLeasetimeSuspend();

            std::string getLeasetimeRemove();

            void start();

            void wakeup();

            void sleep();

            void reboot();

            void reset();

            void shutdown();

            void shutoff();

            void renew();
    };

}

#endif // OCCILIB_COMPUTE_H
