// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#include <string>
#include <vector>

#include "occisession.h"
#include "json.hpp"

using nlohmann::json;
using std::string;
using std::vector;
using namespace OcciClient;

vector<Template> getTemplates(OcciSession* session){
    json mixins = session->queryInterface()["mixins"];
    auto result = std::vector<Template>();
    for (auto& mixin : mixins) {
        if (mixin["depends"] == "http://schemas.ogf.org/occi/infrastructure#os_tpl") {
            result.push_back(mixin["scheme"].get<string>() + mixin["term"].get<string>());
        }
    }
    return result;
}
