// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.


#ifndef OCCILIB_RESOURCE_H_
#define OCCILIB_RESOURCE_H_

#include <string>

#include "json.hpp"
#include "occisession.h"

namespace OcciClient{

    using std::string;

    class Resource{
	    protected:

            OcciSession* session;
            string id;
            string title;
            nlohmann::json rendering;
            string kind;

            void parseJsonInstance(nlohmann::json instance);

            Resource(OcciSession* session, string kind, nlohmann::json instance);

            string getID(nlohmann::json& rendering);

            template <typename T> T getAttributeFromRendering(nlohmann::json& rendering, const string which, const T defaultValue = T());

	    public:

            string getId();

            string getTitle();

            static nlohmann::json invokeAction(OcciSession* session, string kind, string id, nlohmann::json actionData);

            nlohmann::json invokeAction(nlohmann::json actionData);

            nlohmann::json getRendering();

            void destroyInstance();
    };
}

#endif // OCCILIB_RESOURCE_H_
