// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#include <string>

#include "json.hpp"
#include "occisession.h"

#include "resource.h"

using std::string;
using nlohmann::json;
using namespace OcciClient;

void Resource::parseJsonInstance(json instance) {
    this->id = getID(instance);
    if (instance.find("title") != instance.end()) {
        this->title = instance["title"].get<string>();
    }
    this->rendering = instance;
}

Resource::Resource(OcciSession* session, string kind, json instance) {
    this->session = session;
    this->kind = kind;
    parseJsonInstance(instance);
}

string Resource::getID(json& rendering) {
    try {
        return rendering["id"];
    }
    catch (std::domain_error) {
        return "";
    }
}

template <typename T> T Resource::getAttributeFromRendering(json& rendering, const string which, const T defaultValue) {
    try {
        return rendering["attributes"][which].get<T>();
    }
    catch (std::exception e){
        return defaultValue;
    }
}

string Resource::getId(){
    return this->id;
}

string Resource::getTitle(){
    return this->title;
}

json Resource::invokeAction(OcciSession* session, string kind, string id, json actionData) {
    auto uri = kind + "/" + id + "/";
    return session->post(uri, actionData);
}

json Resource::invokeAction(json actionData){
    return invokeAction(this->session, this->kind, this->id, actionData);
}

json Resource::getRendering(){
    return this->rendering;
}

void Resource::destroyInstance() {
    auto uri = this->kind + "/" + this->id + "/";
    session->del(uri);
}
