// Copyright 2017 Budapest University of Technology and Economics (BME IK)
//
// This file is part of CIRCLE Cloud.
//
// CIRCLE is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

#ifndef OCCILIB_NETWORK_H_
#define OCCILIB_NETWORK_H_

#include <string>

#include "json.hpp"
#include "resource.h"

namespace OcciClient {

    class Network : public Resource {

        private:

            std::string state;
            std::string stateMessage;
            int vlan;
            std::string address;
            std::string gateway;
            std::string allocation;

            void parseJsonInstance(nlohmann::json instance);

            Network(OcciSession* session, nlohmann::json instance);

            void invokeAction(nlohmann::json actionData);

        public:

            static std::shared_ptr<Network> getNetworkInstance(OcciSession* session, std::string id);

            std::string getState();

            std::string getStateMessage();

            int getVlan();

            std::string getAddress();

            std::string getGateway();

            std::string getAllocation();
    };

}

#endif // OCCILIB_NETWORK_H
