#include <iostream>

#include "occilib.h"

using OcciClient::OcciSession;
using OcciClient::Compute;
using std::endl;
using std::cout;
using std::shared_ptr;

int main() {
    shared_ptr<OcciSession> session(new OcciSession("https://vm.ik.bme.hu:15766/occi/", true, true));
    session->circleOcciLogin("admin", "retekretek");

    cout << "Templates: ";
    auto ts = OcciClient::getTemplates(session.get());
    for (auto& t : ts){
        cout << t << ", ";
    }
    cout << endl;

    auto comp = Compute::getComputeInstance(session.get(), "96");
    comp->wakeup();
    cout << comp->getStateMessage() << endl;
    comp->sleep();
    cout << comp->getStateMessage() << endl;
    cout << "To connect to this compute instance use the \"" << comp->getCredentialCommand() << "\" command." << endl;

    auto comp2 = Compute::createComputeInstance(session.get(), ts.back());
    cout << "id: " << comp2->getId() << ", title: " << comp2->getTitle() << endl;
    comp2->destroyInstance();

    auto comp3 = Compute::getComputeInstance(session.get(), "96");
    // not exists :'(
}
