# Copyright 2014 Budapest University of Technology and Economics (BME IK)
#
# This file is part of CIRCLE Cloud.
#
# CIRCLE is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# CIRCLE is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along
# with CIRCLE.  If not, see <http://www.gnu.org/licenses/>.

from django.core.management.base import BaseCommand
from vm.models import Instance, InstanceTemplate


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('-t', '--template', type=int, required=True)
        parser.add_argument('-u', '--users', required=True)
        parser.add_argument('-a', '--admin')
        parser.add_argument('-o', '--operator')

    def handle(self, *args, **options):
        template = InstanceTemplate.objects.get(id=options['template'])

        with open(options['users']) as f:
            users = f.read().splitlines()

        missing_users = Instance.mass_create_for_users(
            template, users, options['admin'],  options['operator']
        )

        if len(missing_users) > 0:
            self.stdout.write('These users do not exist:')
            for user in missing_users:
                self.stdout.write(user)
