from django.core.management.base import BaseCommand
from vm.models import Instance, InstanceTemplate


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('template_id', type=int)
        parser.add_argument('users_path')

    def handle(self, *args, **options):
        template = InstanceTemplate.objects.get(id=options['template_id'])
        with open(options['users_path']) as f:
            users = f.read().splitlines()
        missing_users = Instance.mass_create_for_users(template, users)
        if len(missing_users) > 0:
            self.stdout.write('These users do not exist:')
            for user in missing_users:
                self.stdout.write(user)
