$(function() {
  var in_progress = false;
  var activity_hash = 5;
  var show_all = false;
  var reload_vm_detail = false;

  /* do we need to check for new activities */
  if(decideActivityRefresh()) {
    if(!in_progress) {
      checkNewActivity(1);
      in_progress = true;
    }
  }

  $('a[href="#activity"]').click(function(){
    $('a[href="#activity"] i').addClass('fa-spin');
    if(!in_progress) {
      checkNewActivity(1);
      in_progress = true;
    }
  });

  $("#activity-refresh").on("click", "#show-all-activities", function() {
    $(this).find("i").addClass("fa-spinner fa-spin");
    show_all = !show_all;
    $('a[href="#activity"]').trigger("click");
    return false;
  });

  function spinDisks() {
    $('#disks-spinner').show().addClass('fa-spin');
  }

  $(function () {
    $('#storage-link').on('click', function () {
      $('#storage-link-spinner')
        .show()
        .addClass('fa-spin');
    });
  });

  // Datastore autosubmit spinner 
  $('select[data-autosubmit="1"]').on('change', function () { 
    $('#ds-spinner')
    .show()
    .addClass('fa-spin'); 
  });

  // Filter clicks 
  $('.storage-filter').on('click', function () { 
    spinDisks(); 
  }); 

  // Search submit 
  $('#network-host-list-form').on('submit', function () {
    spinDisks(); 
  });

  $(function () {
    $('.nav-spinner').on('click', function () {
      $(this).find('.fa-spinner')
        .show()
        .addClass('fa-spin');
    });
  });

  function showConfirmationModal(data) {
    // ha valamiért bent maradt egy régi modal, takarítsuk (örökölt kódnál előfordul)
    $('#confirmation-modal').remove();
  
    $('body').append(data);
  
    var $modal = $('#confirmation-modal');
    $modal.modal('show');
  
    initAutocompleteSelect2($modal);
  
    // egyszer fusson csak
    $modal.one('hidden.bs.modal', function () {
      $modal.remove();
    });
  
    return $modal;
  }
  
  /* operations */
  $('#ops, #vm-details-resources-disk, #vm-details-renew-op, #vm-details-pw-reset, #vm-details-add-interface, .operation-wrapper')
    .on('click', '.operation', function (e) {
      e.preventDefault();
  
      var $icon = $(this).children("i").addClass('fa-spinner fa-spin');
  
      $.ajax({
        type: 'GET',
        url: $(this).attr('href'),
        success: function (data) {
          $icon.removeClass("fa-spinner fa-spin");
  
          var $modal = showConfirmationModal(data);
  
          // megmaradt a korábbi, specifikus UI tweak
          $modal.find('#vm-migrate-node-list li input:checked').closest('li').addClass('panel-primary');
        },
        error: function () {
          $icon.removeClass("fa-spinner fa-spin");
        }
      });
    });
  
  /* if the operation fails show the modal again */
  /* submit only the operation form via AJAX (JSON response expected) */
  $("body").on("submit", "#confirmation-modal form", function (e) {
    var $form = $(this);
  
    // Only intercept the modal "operation" form submission.
    // If the form does NOT contain the op submit button, let the browser handle it normally
    // (redirects, GET forms, multi-step forms, etc.).
    if ($form.find("#op-form-send").length === 0) {
      return true;
    }
  
    e.preventDefault();
  
    var url = $form.attr("action");
  
    $.ajax({
      url: url,
      headers: { "X-CSRFToken": getCookie('csrftoken') },
      type: 'POST',
      data: $form.serialize(),
      success: function (data) {
        $('#confirmation-modal').modal("hide");
  
        if (data && data.success) {
          $('a[href="#activity"]').trigger("click");
  
          if (data.with_reload) {
            reload_vm_detail = true;
          }
  
          if (data.messages && data.messages.length > 0) {
            addMessage(data.messages.join("<br />"), data.success ? "success" : "danger");
          }
        } else {
          $('#confirmation-modal').one('hidden.bs.modal', function () {
            showConfirmationModal(data);
          });
        }
      },
      error: function (xhr) {
        $('#confirmation-modal').modal("hide");
  
        if (xhr.status === 500) {
          addMessage("500 Internal Server Error", "danger");
        } else if (xhr.status === 405) {
          addMessage("405 Method Not Allowed", "danger");
        } else {
          addMessage(xhr.status + " Unknown Error", "danger");
        }
      }
    });
  
    return false;
  });


  function decideActivityRefresh() {
    var check = false;
    /* if something is still spinning */
    if($('.timeline .activity i').hasClass('fa-spin'))
      check = true;

    return check;
  }

  function checkNewActivity(runs) {
    $.ajax({
      type: 'GET',
      url: $('a[href="#activity"]').attr('data-activity-url'),
      data: {'show_all': show_all},
      success: function(data) {
        var new_activity_hash = (data.activities + "").hashCode();
        if(new_activity_hash != activity_hash) {
          $("#activity-refresh").html(data.activities);
        }
        activity_hash = new_activity_hash;

        $("#ops").html(data.ops);
        $("#disk-ops").html(data.disk_ops);
        $("[title]").tooltip();

        /* changing the status text */
        var icon = $("#vm-details-state i");
        if(data.is_new_state) {
          if(!icon.hasClass("fa-spin"))
            icon.prop("class", "fa fa-spinner fa-spin");
        } else {
          icon.prop("class", "fa " + data.icon);
        }
        var vm_state = $("#vm-details-state");
        if (vm_state.length) {
          vm_state.data("status", data['status']); // jshint ignore:line
          $("#vm-details-state span").html(data.human_readable_status.toUpperCase());
        }
        if(data['status'] == "RUNNING") {  // jshint ignore:line
          if(data.connect_uri) {
              $("#dashboard-vm-details-connect-button").removeClass('disabled');
          }
          $("[data-target=#_console]").attr("data-toggle", "pill").attr("href", "#console").parent("li").removeClass("disabled");
          $("#getScreenshotButton").prop("disabled", false);
        } else {
          if(data.connect_uri) {
              $("#dashboard-vm-details-connect-button").addClass('disabled');
          }
          $("[data-target=#_console]").attr("data-toggle", "_pill").attr("href", "#").parent("li").addClass("disabled");
          $("#getScreenshotButton").prop("disabled", true);
        }

        if(data.status == "STOPPED" || data.status == "PENDING") {
          $(".change-resources-button").prop("disabled", false);
          $(".change-resources-help").hide();
        } else {
          $(".change-resources-button").prop("disabled", true);
          $(".change-resources-help").show();
        }

        if(runs > 0 && decideActivityRefresh()) {
          setTimeout(
            function() {checkNewActivity(runs + 1);},
            1000 + Math.exp(runs * 0.05)
          );
        } else {
          in_progress = false;
          if(document.hasFocus() === false && userWantNotifications()){
            sendNotification(generateMessageFromLastActivity());
          }
          if(reload_vm_detail) location.reload();
          if(runs > 1) addConnectText();
        }
        $('a[href="#activity"] i').removeClass('fa-spin');
      },
      error: function() {
        in_progress = false;
      }
    });
  }
});

// Notification init
$(function(){
  if(userWantNotifications())
    Notification.requestPermission();
});

function generateMessageFromLastActivity(){
  var ac = $("div.activity").first();
  var error = ac.children(".timeline-icon-failed").length;
  var sign = (error === 1) ? "❌ " : "✓ ";
  var msg = ac.children("strong").text().replace(/\s+/g, " ");
  return sign + msg;
}

function sendNotification(message) {
  var options = { icon: "/static/dashboard/img/favicon.png"};
  if (Notification.permission === "granted") {
    var notification = new Notification(message, options);
  }
  else if (Notification.permission !== "denied") {
    Notification.requestPermission(function (permission) {
      if (permission === "granted") {
        var notification = new Notification(message, options);
      }
    });
  }
}

function userWantNotifications(){
  var dn = $("#user-options").data("desktop_notifications");
  return dn === "True";
}

function addConnectText() {
  var activities = $(".timeline .activity");
  if(activities.length > 1) {
    if(activities.eq(0).data("activity-code") == "vm.Instance.wake_up" ||
       activities.eq(0).data("activity-code") == "vm.Instance.agent") {
      $("#vm-detail-successful-boot").slideDown(500);
    }
  }
}

String.prototype.hashCode = function() {
  var hash = 0, i, chr, len;
  if (this.length === 0) return hash;
  for (i = 0, len = this.length; i < len; i++) {
    chr   = this.charCodeAt(i);
    hash  = ((hash << 5) - hash) + chr;
    hash |= 0; // Convert to 32bit integer
  }
  return hash;
};
