; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "CIRCLE Client"
#define MyAppProgramInfo "Visit the CIRCLE"
#define MyAppProgram "Cloud GUI.url"
#define MyAppDir "{userappdata}\CIRCLE"
#define MyAppVersion "1.0"
#define MyAppPublisher "BME IK, IIT, VIK"
#define MyAppURL "http://cloud.bme.hu/"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{86EFCEF4-69E1-4AE5-BF33-30FE7117F45D}
ExtraDiskSpaceRequired=2097140
PrivilegesRequired=poweruser
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={localappdata}\CIRCLE
DisableDirPage=yes
DefaultGroupName={#MyAppName}
AllowNoIcons=yes
OutputBaseFilename=setup
SetupIconFile=installer\cloud.ico
UninstallIconFile=installer\cloud.ico
Compression=lzma
SolidCompression=yes

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "hungarian"; MessagesFile: "compiler:Languages\Hungarian.isl"

[Files]
; "installer" folder contains every necessary files except the uninstall.bat
Source: "installer\*"; DestDir: "{tmp}"; Flags: ignoreversion recursesubdirs createallsubdirs
; "uninstaller" folder contains ONLY the uninstall.bat
Source: "uninstaller\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Code]
procedure CurPageChanged(CurPageID: Integer);
var
  ErrorCode: Integer;
  show_stuff: String;
  install_selenium: String;
  page: String;
  command: String;
  OldState: Boolean;
begin
  show_stuff := 'True';
  install_selenium := 'False';
  page := 'https://cloud.bme.hu/'
  command := show_stuff + ' ' + install_selenium + ' ' + AddQuotes(page)
  case CurPageID of
    wpFinished:
    begin
      if IsWin64 then
      begin
        OldState := EnableFsRedirection(False);
      end;
      try
        Exec(ExpandConstant('{cmd}'), '/C '+AddQuotes(ExpandConstant('{tmp}\install.bat'))+ ' ' + command, '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
      finally
        if IsWin64 then
        begin
          EnableFsRedirection(OldState);
        end;
      end;
    end; 
  end;
end;

[UninstallRun]
Filename: "{app}\uninstall.bat"; Parameters: "True"; Flags: waituntilterminated runascurrentuser shellexec

[Icons]
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
Name: "{group}\{#MyAppProgramInfo}"; Filename: "{#MyAppDir}\{#MyAppProgram}"; IconFilename: "{#MyAppDir}\cloud.ico"

