/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum CookieManagerMessage implements Message
{
    GET_COOKIE(1),
    REMOVE_COOKIE(2),
    REMOVE_ALL_COOKIES(3),
    GET_COOKIE_SETTINGS(4),
    DEFAULT(-1);

    private static final Map<Integer, CookieManagerMessage> lookup;
    private final int code;

    private CookieManagerMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "cookie-manager";
    }

    public static CookieManagerMessage get(int code) {
        CookieManagerMessage command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex(ImmutableList.copyOf(CookieManagerMessage.values()), new Function<CookieManagerMessage, Integer>(){

            @Override
            public Integer apply(CookieManagerMessage message) {
                return message.getID();
            }
        });
    }
}

