/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.StringReader;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.css.sac.InputSource;

@JsxClass(domClass=HtmlStyle.class)
public class HTMLStyleElement
extends HTMLElement {
    private CSSStyleSheet sheet_;

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public CSSStyleSheet getSheet() {
        if (this.sheet_ != null) {
            return this.sheet_;
        }
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        String css = style.getTextContent();
        Cache cache = this.getWindow().getWebWindow().getWebClient().getCache();
        org.w3c.dom.css.CSSStyleSheet cached = cache.getCachedStyleSheet(css);
        String uri = this.getDomNodeOrDie().getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
        if (cached != null) {
            this.sheet_ = new CSSStyleSheet((HTMLElement)this, cached, uri);
        } else {
            InputSource source = new InputSource(new StringReader(css));
            this.sheet_ = new CSSStyleSheet((HTMLElement)this, source, uri);
            cache.cache(css, this.sheet_.getWrappedSheet());
        }
        return this.sheet_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public CSSStyleSheet getStyleSheet() {
        return this.getSheet();
    }

    @JsxGetter
    public String getType() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getTypeAttribute();
    }

    @JsxSetter
    public void setType(String type) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setTypeAttribute(type);
    }

    @JsxGetter
    public String getMedia() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getAttribute("media");
    }

    @Override
    @JsxSetter
    public void setInnerHTML(Object value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_READONLY_FOR_SOME_TAGS)) {
            throw Context.reportRuntimeError("innerHTML is read-only for tag 'style'");
        }
        super.setInnerHTML(value);
    }
}

