/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.security.authentication;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seleniumhq.jetty7.security.ServerAuthException;
import org.seleniumhq.jetty7.security.UserAuthentication;
import org.seleniumhq.jetty7.security.authentication.DeferredAuthentication;
import org.seleniumhq.jetty7.security.authentication.LoginAuthenticator;
import org.seleniumhq.jetty7.server.Authentication;
import org.seleniumhq.jetty7.server.UserIdentity;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

public class SpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(SpnegoAuthenticator.class);

    public String getAuthMethod() {
        return "SPNEGO";
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        String spnegoToken;
        UserIdentity user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String header = req.getHeader("Authorization");
        if (!mandatory) {
            return this._deferred;
        }
        if (header == null) {
            try {
                if (DeferredAuthentication.isDeferred(res)) {
                    return Authentication.UNAUTHENTICATED;
                }
                LOG.debug("SpengoAuthenticator: sending challenge", new Object[0]);
                res.setHeader("WWW-Authenticate", "Negotiate");
                res.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException ioe) {
                throw new ServerAuthException(ioe);
            }
        }
        if (header != null && header.startsWith("Negotiate") && (user = this._loginService.login(null, spnegoToken = header.substring(10))) != null) {
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

