/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import javax.net.SocketFactory;
import org.seleniumhq.jetty7.client.Address;
import org.seleniumhq.jetty7.client.BlockingHttpConnection;
import org.seleniumhq.jetty7.client.HttpClient;
import org.seleniumhq.jetty7.client.HttpDestination;
import org.seleniumhq.jetty7.io.Connection;
import org.seleniumhq.jetty7.io.bio.SocketEndPoint;
import org.seleniumhq.jetty7.util.component.AbstractLifeCycle;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

class SocketConnector
extends AbstractLifeCycle
implements HttpClient.Connector {
    private static final Logger LOG = Log.getLogger(SocketConnector.class);
    private final HttpClient _httpClient;

    SocketConnector(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public void startConnection(final HttpDestination destination) throws IOException {
        Socket socket = destination.isSecure() ? this._httpClient.getSslContextFactory().newSslSocket() : SocketFactory.getDefault().createSocket();
        socket.setSoTimeout(0);
        socket.setTcpNoDelay(true);
        Address address = destination.isProxied() ? destination.getProxy() : destination.getAddress();
        socket.connect(address.toSocketAddress(), this._httpClient.getConnectTimeout());
        SocketEndPoint endpoint = new SocketEndPoint(socket);
        final BlockingHttpConnection connection = new BlockingHttpConnection(this._httpClient.getRequestBuffers(), this._httpClient.getResponseBuffers(), endpoint);
        connection.setDestination(destination);
        destination.onNewConnection(connection);
        this._httpClient.getThreadPool().dispatch(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Connection next;
                    Connection con = connection;
                    while ((next = con.handle()) != con) {
                        con = next;
                    }
                }
                catch (IOException e) {
                    if (e instanceof InterruptedIOException) {
                        LOG.ignore(e);
                    } else {
                        LOG.debug(e);
                        destination.onException(e);
                    }
                }
                finally {
                    try {
                        destination.returnConnection(connection, true);
                    }
                    catch (IOException e) {
                        LOG.debug(e);
                    }
                }
            }
        });
    }
}

