/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.mobile;

public interface NetworkConnection {
    public ConnectionType getNetworkConnection();

    public ConnectionType setNetworkConnection(ConnectionType var1);

    public static class ConnectionType {
        public static final ConnectionType WIFI = new ConnectionType(2);
        public static final ConnectionType DATA = new ConnectionType(4);
        public static final ConnectionType AIRPLANE_MODE = new ConnectionType(1);
        public static final ConnectionType ALL = new ConnectionType(6);
        public static final ConnectionType NONE = new ConnectionType(0);
        private int mask = 0;

        public ConnectionType(Boolean wifi, Boolean data, Boolean airplaneMode) {
            if (wifi.booleanValue()) {
                this.mask += ConnectionType.WIFI.mask;
            }
            if (data.booleanValue()) {
                this.mask += ConnectionType.DATA.mask;
            }
            if (airplaneMode.booleanValue()) {
                this.mask += ConnectionType.AIRPLANE_MODE.mask;
            }
        }

        public ConnectionType(int mask) {
            this.mask = Math.max(mask, 0);
        }

        public Boolean isAirplaneMode() {
            if (this.mask % 2 == 1) {
                return true;
            }
            return false;
        }

        public Boolean isWifiEnabled() {
            if (this.mask / 2 % 2 == 1) {
                return true;
            }
            return false;
        }

        public Boolean isDataEnabled() {
            if (this.mask / 4 > 0) {
                return true;
            }
            return false;
        }

        public boolean equals(Object type) {
            return type instanceof ConnectionType && this.mask == ((ConnectionType)type).mask;
        }

        public String toString() {
            return Integer.toString(this.mask);
        }
    }
}

