/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Platform {
    WINDOWS(new String[]{""}){

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == XP || compareWith == VISTA || compareWith == WIN8;
        }
    }
    ,
    XP(new String[]{"Windows Server 2003", "xp", "windows", "winnt"}){

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == XP;
        }
    }
    ,
    VISTA(new String[]{"windows vista", "Windows Server 2008", "windows 7", "win7"}){

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == VISTA;
        }
    }
    ,
    WIN8(new String[]{"Windows Server 2012", "windows 8", "win8"}){

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == WIN8;
        }
    }
    ,
    WIN8_1(new String[]{"windows 8.1", "win8.1"}){

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == WIN8_1;
        }
    }
    ,
    MAC(new String[]{"mac", "darwin"}){}
    ,
    UNIX(new String[]{"solaris", "bsd"}){}
    ,
    LINUX(new String[]{"linux"}){

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == UNIX || compareWith == LINUX;
        }
    }
    ,
    ANDROID(new String[]{"android", "dalvik"}){

        public String getLineEnding() {
            return "\n";
        }

        @Override
        public boolean is(Platform compareWith) {
            return compareWith == LINUX || compareWith == ANDROID;
        }
    }
    ,
    ANY(new String[]{""}){

        @Override
        public boolean is(Platform compareWith) {
            return true;
        }
    };

    private final String[] partOfOsName;
    private final int minorVersion;
    private final int majorVersion;

    private Platform(String ... partOfOsName) {
        this.partOfOsName = partOfOsName;
        String version = System.getProperty("os.version", "0.0.0");
        int major = 0;
        int min = 0;
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+).*");
        Matcher matcher = pattern.matcher(version);
        if (matcher.matches()) {
            try {
                major = Integer.parseInt(matcher.group(1));
                min = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.majorVersion = major;
        this.minorVersion = min;
    }

    public String[] getPartOfOsName() {
        return this.partOfOsName;
    }

    public static Platform getCurrent() {
        return Platform.extractFromSysProperty(System.getProperty("os.name"));
    }

    public static Platform extractFromSysProperty(String osName) {
        return Platform.extractFromSysProperty(osName, System.getProperty("os.version"));
    }

    public static Platform extractFromSysProperty(String osName, String osVersion) {
        osName = osName.toLowerCase();
        if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
            return ANDROID;
        }
        if (osVersion.equals("6.2") && osName.startsWith("windows nt")) {
            return WIN8;
        }
        if (osVersion.equals("6.3") && osName.startsWith("windows nt")) {
            return WIN8_1;
        }
        Platform mostLikely = UNIX;
        String previousMatch = null;
        Platform[] platformArray = Platform.values();
        int n = platformArray.length;
        int n2 = 0;
        while (n2 < n) {
            Platform os = platformArray[n2];
            String[] stringArray = os.partOfOsName;
            int n3 = os.partOfOsName.length;
            int n4 = 0;
            while (n4 < n3) {
                String matcher = stringArray[n4];
                if (!"".equals(matcher)) {
                    if (os.isExactMatch(osName, matcher = matcher.toLowerCase())) {
                        return os;
                    }
                    if (os.isCurrentPlatform(osName, matcher) && Platform.isBetterMatch(previousMatch, matcher)) {
                        previousMatch = matcher;
                        mostLikely = os;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return mostLikely;
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        return previous == null || matcher.length() >= previous.length();
    }

    public boolean is(Platform compareWith) {
        return this.equals((Object)compareWith);
    }

    private boolean isCurrentPlatform(String osName, String matchAgainst) {
        return osName.contains(matchAgainst);
    }

    private boolean isExactMatch(String osName, String matchAgainst) {
        return matchAgainst.equals(osName);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    /* synthetic */ Platform(String string, int n, String[] stringArray, Platform platform) {
        this(stringArray);
    }
}

