/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.internal.ServiceCallback;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.Selftest;
import com.opera.core.systems.scope.stp.services.messages.SelftestMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;

public class ScopeSelftest
extends AbstractService
implements Selftest {
    private ServiceCallback<SelftestProtos.SelftestResult> callback = null;

    public ScopeSelftest(ScopeServices services) {
        super(services, "selftest");
        if (!this.isVersionInRange("2.0")) {
            return;
        }
        services.setSelftest(this);
    }

    @Override
    public void init() {
    }

    @Override
    public Selftest.RunStatus runSelftests(Set<String> modules, String groups, String excludes) {
        Preconditions.checkNotNull(modules, "Modules cannot be empty");
        SelftestProtos.RunTestsArg.Builder argBuilder = SelftestProtos.RunTestsArg.newBuilder();
        if (groups != null) {
            argBuilder.setTestPattern(groups);
        }
        argBuilder.setModuleList(Joiner.on(',').join(modules));
        if (excludes != null) {
            argBuilder.setExcludePattern(excludes);
        }
        UmsProtos.Response response = this.executeMessage(SelftestMessage.RUN_TESTS, argBuilder);
        SelftestProtos.RunStatus.Builder builder = SelftestProtos.RunStatus.newBuilder();
        ScopeSelftest.buildPayload(response, builder);
        SelftestProtos.RunStatus.RunTestStatus status = builder.build().getStatus();
        switch (status) {
            case RUNNING: {
                return Selftest.RunStatus.RUNNING;
            }
            case NOT_AVAILABLE: {
                return Selftest.RunStatus.NOT_AVAILABLE;
            }
        }
        throw new WebDriverException(String.format("Unknown result: %s", status));
    }

    @Override
    public void addResult(SelftestProtos.SelftestResult result) {
        this.callback.call(result);
    }

    @Override
    public void onSelftestResult(ServiceCallback<SelftestProtos.SelftestResult> callback) {
        this.callback = callback;
    }

    @Override
    public Map<String, List<String>> getAvailableGroups() {
        UmsProtos.Response response = this.executeMessage(SelftestMessage.GET_TESTSGROUPS);
        SelftestProtos.GroupList.Builder builder = SelftestProtos.GroupList.newBuilder();
        ScopeSelftest.buildPayload(response, builder);
        ImmutableMap.Builder returnModules = ImmutableMap.builder();
        for (SelftestProtos.GroupInformation groupInfo : builder.build().getGroupListList()) {
            if (returnModules.build().containsKey(groupInfo.getModule())) {
                ((List)returnModules.build().get(groupInfo.getModule())).add(groupInfo.getName());
                continue;
            }
            LinkedList<String> group = Lists.newLinkedList();
            group.add(groupInfo.getName());
            returnModules.put(groupInfo.getModule(), group);
        }
        return returnModules.build();
    }

    public static class ScopeSelftestResult
    implements Selftest.SelftestResult {
        private String testName = null;
        private String groupName = null;
        private String fileName = null;
        private Selftest.SelftestResult.Result result = Selftest.SelftestResult.Result.FAIL;
        private String reason = null;
        private int lineNumber = 0;

        @Override
        public String getTestName() {
            return this.testName;
        }

        @Override
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public Selftest.SelftestResult.Result getResult() {
            return this.result;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        public String toString() {
            return String.format("%s:%s:%s:%s", new Object[]{this.testName, this.groupName, this.result, this.reason});
        }

        public boolean equals(Object other) {
            if (!(other instanceof Selftest.SelftestResult)) {
                return false;
            }
            ScopeSelftestResult result = (ScopeSelftestResult)other;
            return result.testName.equals(this.testName) && result.groupName.equals(this.groupName) && result.result == this.result && result.lineNumber == this.lineNumber && (result.reason == null || result.reason.equals(this.reason));
        }

        public JSONObject toJson() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("testName", this.testName);
            json.put("groupName", this.groupName);
            json.put("result", (Object)this.result);
            json.put("reason", this.reason);
            json.put("fileName", this.fileName);
            json.put("lineNumber", this.lineNumber);
            return json;
        }

        public Selftest.SelftestResult fromJson(JSONObject json) throws JSONException {
            return ScopeSelftestResult.builder().setTestName(String.valueOf(json.get("testName"))).setGroupName(String.valueOf(json.get("groupName"))).setFileName(String.valueOf(json.get("fileName"))).setTestResult(Selftest.SelftestResult.Result.valueOf(String.valueOf(json.get("result")))).setReason(String.valueOf(json.get("reason"))).setLineNumber(Integer.parseInt(String.valueOf(json.get("lineNumber")))).build();
        }

        public static Selftest.SelftestResult.Result convertProtoResult(SelftestProtos.SelftestResult.Result result) {
            switch (result) {
                case PASS: {
                    return Selftest.SelftestResult.Result.PASS;
                }
                case SKIP: {
                    return Selftest.SelftestResult.Result.SKIP;
                }
            }
            return Selftest.SelftestResult.Result.FAIL;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final ScopeSelftestResult result = new ScopeSelftestResult();

            public Selftest.SelftestResult build() {
                return this.result;
            }

            public Builder setTestName(String testName) {
                this.result.testName = testName;
                return this;
            }

            public Builder setGroupName(String groupName) {
                this.result.groupName = groupName;
                return this;
            }

            public Builder setFileName(String fileName) {
                this.result.fileName = fileName;
                return this;
            }

            public Builder setTestResult(Selftest.SelftestResult.Result result) {
                this.result.result = result;
                return this;
            }

            public Builder setReason(String reason) {
                this.result.reason = reason;
                return this;
            }

            public Builder setLineNumber(int lineNumber) {
                this.result.lineNumber = lineNumber;
                return this;
            }
        }
    }
}

