/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.InsecureTrustManager2;
import com.gargoylesoftware.htmlunit.SocksConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;

final class HtmlUnitSSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    private static final String SSL3ONLY = "htmlunit.SSL3Only";

    static void setUseSSL3Only(HttpContext parameters, boolean ssl3Only) {
        parameters.setAttribute(SSL3ONLY, ssl3Only);
    }

    static boolean isUseSSL3Only(HttpContext context) {
        return "TRUE".equalsIgnoreCase((String)context.getAttribute(SSL3ONLY));
    }

    public static SSLConnectionSocketFactory buildSSLSocketFactory(WebClientOptions options) {
        try {
            if (!options.isUseInsecureSSL()) {
                if (options.getSSLClientCertificateUrl() == null) {
                    return new HtmlUnitSSLConnectionSocketFactory((KeyStore)null, null);
                }
                return new HtmlUnitSSLConnectionSocketFactory(HtmlUnitSSLConnectionSocketFactory.getKeyStore(options), options.getSSLClientCertificatePassword());
            }
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(HtmlUnitSSLConnectionSocketFactory.getKeyManagers(options), new TrustManager[]{new InsecureTrustManager2()}, null);
            HtmlUnitSSLConnectionSocketFactory factory = new HtmlUnitSSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return factory;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private HtmlUnitSSLConnectionSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
    }

    private HtmlUnitSSLConnectionSocketFactory(KeyStore keystore, String keystorePassword) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(SSLContexts.custom().loadKeyMaterial(keystore, keystorePassword != null ? keystorePassword.toCharArray() : null).build(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    private void configureSocket(SSLSocket sslSocket, HttpContext context) {
        if (HtmlUnitSSLConnectionSocketFactory.isUseSSL3Only(context)) {
            sslSocket.setEnabledProtocols(new String[]{"SSLv3"});
        }
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        HttpHost socksProxy = SocksConnectionSocketFactory.getSocksProxy(context);
        if (socksProxy != null) {
            Socket underlying = SocksConnectionSocketFactory.createSocketWithSocksProxy(socksProxy);
            underlying.setReuseAddress(true);
            InetSocketAddress socksProxyAddress = new InetSocketAddress(socksProxy.getHostName(), socksProxy.getPort());
            try {
                underlying.connect(remoteAddress, connectTimeout);
            }
            catch (SocketTimeoutException ex) {
                throw new ConnectTimeoutException("Connect to " + socksProxyAddress + " timed out");
            }
            Socket sslSocket = this.getSSLSocketFactory().createSocket(underlying, socksProxy.getHostName(), socksProxy.getPort(), true);
            this.configureSocket((SSLSocket)sslSocket, context);
            return sslSocket;
        }
        return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
    }

    private SSLSocketFactory getSSLSocketFactory() {
        try {
            Field field = SSLConnectionSocketFactory.class.getDeclaredField("socketfactory");
            field.setAccessible(true);
            return (SSLSocketFactory)field.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyManager[] getKeyManagers(WebClientOptions options) {
        if (options.getSSLClientCertificateUrl() == null) {
            return null;
        }
        try {
            String password = options.getSSLClientCertificatePassword();
            char[] passwordChars = password != null ? password.toCharArray() : null;
            KeyStore keyStore = HtmlUnitSSLConnectionSocketFactory.getKeyStore(options);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, passwordChars);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyStore getKeyStore(WebClientOptions options) {
        try {
            KeyStore keyStore = KeyStore.getInstance(options.getSSLClientCertificateType());
            String password = options.getSSLClientCertificatePassword();
            char[] passwordChars = password != null ? password.toCharArray() : null;
            keyStore.load(options.getSSLClientCertificateUrl().openStream(), passwordChars);
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

