/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

public enum Architecture {
    X86(new String[]{"x86", "i386", "ia32", "i686", "i486", "i86", "pentium", "pentium_pro", "pentium_pro+mmx", "pentium+mmx"}){

        @Override
        public int getDataModel() {
            return 32;
        }
    }
    ,
    X64("amd64", "ia64", "x86_64"),
    ARM("arm"),
    MIPS32(new String[]{"mips32"}){

        @Override
        public int getDataModel() {
            return 32;
        }
    }
    ,
    MIPS64("mips64"),
    ANY(new String[]{""}){

        @Override
        public boolean is(Architecture compareWith) {
            return true;
        }
    };

    private final String[] archIdentifiers;

    private Architecture(String ... partOfArch) {
        this.archIdentifiers = partOfArch;
    }

    public boolean is(Architecture compareWith) {
        return this.equals((Object)compareWith);
    }

    public int getDataModel() {
        return 64;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Architecture getCurrent() {
        return Architecture.extractFromSysProperty(System.getProperty("os.arch"));
    }

    public static Architecture extractFromSysProperty(String arch) {
        if (arch != null) {
            arch = arch.toLowerCase();
        }
        Architecture[] architectureArray = Architecture.values();
        int n = architectureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Architecture architecture = architectureArray[n2];
            if (architecture != ANY) {
                String[] stringArray = architecture.archIdentifiers;
                int n3 = architecture.archIdentifiers.length;
                int n4 = 0;
                while (n4 < n3) {
                    String matcher = stringArray[n4];
                    if (matcher.equals(arch)) {
                        return architecture;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        throw new UnsupportedOperationException("Unknown architecture: " + arch);
    }

    /* synthetic */ Architecture(String string, int n, String[] stringArray, Architecture architecture) {
        this(stringArray);
    }
}

