/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.SocksConnectionSocketFactory;
import java.lang.reflect.Field;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.TextUtils;

final class HtmlUnitHttpClientBuilder {
    private HtmlUnitHttpClientBuilder() {
    }

    public static void configureConnectionManager(HttpClientBuilder builder) {
        String s;
        SocksConnectionSocketFactory socketFactory = new SocksConnectionSocketFactory();
        LayeredConnectionSocketFactory sslSocketFactory = (LayeredConnectionSocketFactory)HtmlUnitHttpClientBuilder.getField(builder, "sslSocketFactory");
        SocketConfig defaultSocketConfig = (SocketConfig)HtmlUnitHttpClientBuilder.getField(builder, "defaultSocketConfig");
        ConnectionConfig defaultConnectionConfig = (ConnectionConfig)HtmlUnitHttpClientBuilder.getField(builder, "defaultConnectionConfig");
        boolean systemProperties = (Boolean)HtmlUnitHttpClientBuilder.getField(builder, "systemProperties");
        int maxConnTotal = (Integer)HtmlUnitHttpClientBuilder.getField(builder, "maxConnTotal");
        int maxConnPerRoute = (Integer)HtmlUnitHttpClientBuilder.getField(builder, "maxConnPerRoute");
        X509HostnameVerifier hostnameVerifier = (X509HostnameVerifier)HtmlUnitHttpClientBuilder.getField(builder, "hostnameVerifier");
        SSLContext sslcontext = (SSLContext)HtmlUnitHttpClientBuilder.getField(builder, "sslcontext");
        if (sslSocketFactory == null) {
            String[] supportedCipherSuites;
            String[] supportedProtocols = systemProperties ? HtmlUnitHttpClientBuilder.split(System.getProperty("https.protocols")) : null;
            String[] stringArray = supportedCipherSuites = systemProperties ? HtmlUnitHttpClientBuilder.split(System.getProperty("https.cipherSuites")) : null;
            if (hostnameVerifier == null) {
                hostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
            }
            sslSocketFactory = sslcontext != null ? new SSLConnectionSocketFactory(sslcontext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (systemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
        }
        PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", socketFactory).register("https", (SocksConnectionSocketFactory)((Object)sslSocketFactory)).build());
        if (defaultSocketConfig != null) {
            poolingmgr.setDefaultSocketConfig(defaultSocketConfig);
        }
        if (defaultConnectionConfig != null) {
            poolingmgr.setDefaultConnectionConfig(defaultConnectionConfig);
        }
        if (systemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
            s = System.getProperty("http.maxConnections", "5");
            int max = Integer.parseInt(s);
            poolingmgr.setDefaultMaxPerRoute(max);
            poolingmgr.setMaxTotal(2 * max);
        }
        if (maxConnTotal > 0) {
            poolingmgr.setMaxTotal(maxConnTotal);
        }
        if (maxConnPerRoute > 0) {
            poolingmgr.setDefaultMaxPerRoute(maxConnPerRoute);
        }
        builder.setConnectionManager(poolingmgr);
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static Object getField(HttpClientBuilder builder, String fieldName) {
        try {
            Field field = HttpClientBuilder.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

