;NSIS Modern User Interface
;Multilingual Cloud Installer Script
;Written by Csk Tams

;--------------------------------
;Include Modules
!include "MUI2.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

;--------------------------------
;Defining new constants
  !define Company "CIRCLE Cloud"
  !define AppName "Client"
  !define AppUrlName "BME CIRCLE"
  !define AppUrl "http://cloud.bme.hu/"
  !define AppUninstaller "Uninstall.exe"
  !define IconName "cloud"
  !define Show_output "True"
  !define Install_selenium "False"
  !define DefaulLocation "$LOCALAPPDATA\CIRCLE"
  
;--------------------------------
;General

  ;Properly display all languages (Installer will not work on Windows 95, 98 or ME!)
  Unicode true
  
  ;Name and file
  Name "${Company} ${AppName}"
  OutFile "..\..\dist\CIRCLE_Client_Setup.exe"
  
  ;Disable to skip files from installing
  AllowSkipFiles off
  
  ;If there are existing files stored try to overwrite it
  SetOverwrite try
  
  ;Default installation folder
  InstallDir "${DefaulLocation}"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKCU "Software\${Company} ${AppName}" "install_directory"
  
  ;Request application privileges
  RequestExecutionLevel admin
    
      
;--------------------------------
;Interface Settings
  !define MUI_ABORTWARNING
  
  !define MUI_ICON "${IconName}.ico"

  !define MUI_UNICON "${IconName}.ico"
  
  ;Show all languages, despite user's codepage
  !define MUI_LANGDLL_ALLLANGUAGES

;--------------------------------
;Language Selection Dialog Settings
;Remember the installer language
  !define MUI_LANGDLL_REGISTRY_ROOT "HKCU" 
  !define MUI_LANGDLL_REGISTRY_KEY "Software\${Company} ${AppName}" 
  !define MUI_LANGDLL_REGISTRY_VALUENAME "Installer Language"
  
;--------------------------------
;Pages
  !insertmacro MUI_PAGE_LICENSE "gpl-3.0.txt"
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  ;Done fuction to launch install.bat
  !define MUI_PAGE_CUSTOMFUNCTION_PRE Done
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  
;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English" ;first language is the default language
  !insertmacro MUI_LANGUAGE "Hungarian"
  !insertmacro MUI_LANGUAGE "French"
  !insertmacro MUI_LANGUAGE "German"
  !insertmacro MUI_LANGUAGE "Spanish"
  !insertmacro MUI_LANGUAGE "SpanishInternational"
  !insertmacro MUI_LANGUAGE "SimpChinese"
  !insertmacro MUI_LANGUAGE "TradChinese"
  !insertmacro MUI_LANGUAGE "Japanese"
  !insertmacro MUI_LANGUAGE "Korean"
  !insertmacro MUI_LANGUAGE "Italian"
  !insertmacro MUI_LANGUAGE "Dutch"
  !insertmacro MUI_LANGUAGE "Danish"
  !insertmacro MUI_LANGUAGE "Swedish"
  !insertmacro MUI_LANGUAGE "Norwegian"
  !insertmacro MUI_LANGUAGE "NorwegianNynorsk"
  !insertmacro MUI_LANGUAGE "Finnish"
  !insertmacro MUI_LANGUAGE "Greek"
  !insertmacro MUI_LANGUAGE "Russian"
  !insertmacro MUI_LANGUAGE "Portuguese"
  !insertmacro MUI_LANGUAGE "PortugueseBR"
  !insertmacro MUI_LANGUAGE "Polish"
  !insertmacro MUI_LANGUAGE "Ukrainian"
  !insertmacro MUI_LANGUAGE "Czech"
  !insertmacro MUI_LANGUAGE "Slovak"
  !insertmacro MUI_LANGUAGE "Croatian"
  !insertmacro MUI_LANGUAGE "Bulgarian"
  !insertmacro MUI_LANGUAGE "Thai"
  !insertmacro MUI_LANGUAGE "Romanian"
  !insertmacro MUI_LANGUAGE "Latvian"
  !insertmacro MUI_LANGUAGE "Macedonian"
  !insertmacro MUI_LANGUAGE "Estonian"
  !insertmacro MUI_LANGUAGE "Turkish"
  !insertmacro MUI_LANGUAGE "Lithuanian"
  !insertmacro MUI_LANGUAGE "Slovenian"
  !insertmacro MUI_LANGUAGE "Serbian"
  !insertmacro MUI_LANGUAGE "SerbianLatin"
  !insertmacro MUI_LANGUAGE "Arabic"
  !insertmacro MUI_LANGUAGE "Farsi"
  !insertmacro MUI_LANGUAGE "Hebrew"
  !insertmacro MUI_LANGUAGE "Indonesian"
  !insertmacro MUI_LANGUAGE "Mongolian"
  !insertmacro MUI_LANGUAGE "Luxembourgish"
  !insertmacro MUI_LANGUAGE "Albanian"
  !insertmacro MUI_LANGUAGE "Breton"
  !insertmacro MUI_LANGUAGE "Belarusian"
  !insertmacro MUI_LANGUAGE "Icelandic"
  !insertmacro MUI_LANGUAGE "Malay"
  !insertmacro MUI_LANGUAGE "Bosnian"
  !insertmacro MUI_LANGUAGE "Kurdish"
  !insertmacro MUI_LANGUAGE "Irish"
  !insertmacro MUI_LANGUAGE "Uzbek"
  !insertmacro MUI_LANGUAGE "Galician"
  !insertmacro MUI_LANGUAGE "Afrikaans"
  !insertmacro MUI_LANGUAGE "Catalan"
  !insertmacro MUI_LANGUAGE "Esperanto"
  !insertmacro MUI_LANGUAGE "Asturian"
  !insertmacro MUI_LANGUAGE "Pashto"
  ;!insertmacro MUI_LANGUAGE "ScotsGaelic"
!ifdef NSIS_UNICODE
  !insertmacro MUI_LANGUAGE "Georgian"
!endif

;--------------------------------
;Reserve Files
  !insertmacro MUI_RESERVEFILE_LANGDLL

;--------------------------------
;Installer Sections
Section "Install Section" SecInstall
  SetOutPath "$INSTDIR"
  
  ;ADD OWN FILES HERE----------------------------------------
  File /r installer
  File /r uninstaller
  
  ;Store installation folder
  WriteRegStr HKCU "Software\${Company} ${AppName}" "install_directory" $INSTDIR
  
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\${AppUninstaller}"
  
  ;Creating ShortCuts
  CreateDirectory '$SMPROGRAMS\${Company}\${AppName}'
  StrCmp $LANGUAGE ${LANG_HUNGARIAN} 0 +3
    WriteINIStr "$SMPROGRAMS\${Company}\Ltogasd meg a ${AppUrlName}-t.url" "InternetShortcut" "URL" "${AppUrl}"
    Goto +2
  WriteINIStr "$SMPROGRAMS\${Company}\Visit the ${AppUrlName}.url" "InternetShortcut" "URL" "${AppUrl}"
  CreateShortCut '$SMPROGRAMS\${Company}\${AppName}\Uninstall ${AppName}.lnk' '$INSTDIR\${AppUninstaller}' "" '$INSTDIR\${AppUninstaller}' 0

SectionEnd
;--------------------------------
;Installer Functions
Function .onInit
  ${If} ${RunningX64}
        ${DisableX64FSRedirection}
        SetRegView 64
  ${EndIf}

  !insertmacro MUI_LANGDLL_DISPLAY

FunctionEnd

Function Done
  ExecWait '"$INSTDIR\installer\install.cmd" "$INSTDIR" ${Show_output} ${Install_selenium} "${AppUrl}" >"$INSTDIR\install.log" 2>"$INSTDIR\install_error.log"'
  
  RMDir /r "$INSTDIR\installer"
FunctionEnd
;--------------------------------
;Descriptions
  ;USE A LANGUAGE STRING IF YOU WANT YOUR DESCRIPTIONS TO BE LANGAUGE SPECIFIC

  ;Assign descriptions to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    StrCmp $LANGUAGE ${LANG_HUNGARIAN} 0 +3
      !insertmacro MUI_DESCRIPTION_TEXT ${SecInstall} "A ${AppName} installlsa"
      Goto +2
    !insertmacro MUI_DESCRIPTION_TEXT ${SecInstall} "Installing the ${AppName}"
      
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
  
  
;--------------------------------
;Uninstaller Section
Section "Uninstall"
  StrCmp $LANGUAGE ${LANG_HUNGARIAN} 0 +4
    IfFileExists "$SMPROGRAMS\${Company}\Ltogasd meg a ${AppUrlName}-t.url" 0 +2
      Delete "$SMPROGRAMS\${Company}\Ltogasd meg a ${AppUrlName}-t.url"
    Goto +3
    IfFileExists "$SMPROGRAMS\${Company}\Visit the ${AppUrlName}.url" 0 +2
      Delete "$SMPROGRAMS\${Company}\Visit the ${AppUrlName}.url"
  
  IfFileExists "$SMPROGRAMS\${Company}\${AppName}\*.*" 0 +2
    RMDir /r "$SMPROGRAMS\${Company}\${AppName}"

  IfFileExists "$SMPROGRAMS\${Company}\*.*" +2 0
    RMDir /r "$SMPROGRAMS\${Company}"
    
  ExecWait '"$INSTDIR\uninstaller\uninstall.cmd" "$INSTDIR" ${Show_output} >"$INSTDIR\uninstall.log" 2>"$INSTDIR\uninstall_error.log"'
    
  IfFileExists "$INSTDIR\uninstaller\*.*" 0 +2
    RMDir /r "$INSTDIR\uninstaller"
  IfFileExists "$INSTDIR\.rdp\*.*" 0 +2
    RMDir /r "$INSTDIR\.rdp"
  IfFileExists "$INSTDIR\client.log" 0 +2
    Delete "$INSTDIR\client.log"
  IfFileExists "$INSTDIR\cloud.py" 0 +2
    Delete "$INSTDIR\cloud.py"
  IfFileExists "$INSTDIR\cloud_connect_from_windows.py" 0 +2
    Delete "$INSTDIR\cloud_connect_from_windows.py"
  IfFileExists "$INSTDIR\nxkey.py" 0 +2
    Delete "$INSTDIR\nxkey.py"
  IfFileExists "$INSTDIR\OrderedDict.py" 0 +2
    Delete "$INSTDIR\OrderedDict.py"
  IfFileExists "$INSTDIR\putty.exe" 0 +2
    Delete "$INSTDIR\putty.exe"
  IfFileExists "$INSTDIR\win_install.py" 0 +2
    Delete "$INSTDIR\win_install.py"
  IfFileExists "$INSTDIR\windowsclasses.py" 0 +2
    Delete "$INSTDIR\windowsclasses.py"
  IfFileExists "$INSTDIR\windowsclasses.pyc" 0 +2
    Delete "$INSTDIR\windowsclasses.pyc"
 
  IfFileExists "$INSTDIR\${AppUninstaller}" 0 +2
    Delete "$INSTDIR\${AppUninstaller}"

  StrCmp $INSTDIR "${DefaulLocation}" 0 +2
    RMDir /r "$INSTDIR"
SectionEnd

;--------------------------------
;Uninstaller Functions
Function un.onInit
  ClearErrors
  ReadRegStr $0 HKCU "Software\${Company} ${AppName}" "install_directory"
  ${If} ${Errors}
    ${IF} $INSTDIR == ""
      StrCpy $INSTDIR "$LOCALAPPDATA\CIRCLE"
    ${ENDIF}
  ${Else}
    ${IF} $0 == ""
       StrCpy $INSTDIR "$LOCALAPPDATA\CIRCLE"
    ${ELSE}
       StrCpy $INSTDIR $0
    ${ENDIF}
  ${EndIf}
  ${If} ${RunningX64}
        ${DisableX64FSRedirection}
        SetRegView 64
  ${EndIf}
  !insertmacro MUI_UNGETLANGUAGE
FunctionEnd
  