/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.util.log;

import java.util.logging.Level;
import org.seleniumhq.jetty7.util.log.AbstractLogger;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

public class JavaUtilLog
extends AbstractLogger {
    private Level configuredLevel;
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.seleniumhq.jetty7.util.log");
    }

    public JavaUtilLog(String name) {
        this._logger = java.util.logging.Logger.getLogger(name);
        if (Boolean.parseBoolean(Log.__props.getProperty("org.seleniumhq.jetty7.util.log.DEBUG", "false"))) {
            this._logger.setLevel(Level.FINE);
        }
        this.configuredLevel = this._logger.getLevel();
    }

    public String getName() {
        return this._logger.getName();
    }

    public void warn(String msg, Object ... args) {
        this._logger.log(Level.WARNING, this.format(msg, args));
    }

    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    public void warn(String msg, Throwable thrown) {
        this._logger.log(Level.WARNING, msg, thrown);
    }

    public void info(String msg, Object ... args) {
        this._logger.log(Level.INFO, this.format(msg, args));
    }

    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    public void info(String msg, Throwable thrown) {
        this._logger.log(Level.INFO, msg, thrown);
    }

    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
        } else {
            this._logger.setLevel(this.configuredLevel);
        }
    }

    public void debug(String msg, Object ... args) {
        this._logger.log(Level.FINE, this.format(msg, args));
    }

    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    public void debug(String msg, Throwable thrown) {
        this._logger.log(Level.FINE, msg, thrown);
    }

    protected Logger newLogger(String fullname) {
        return new JavaUtilLog(fullname);
    }

    public void ignore(Throwable ignored) {
        if (Log.isIgnored()) {
            this.warn("IGNORED ", ignored);
        }
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

