/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import java.awt.Robot;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpFields;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.handler.ResourceHandler;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.browserlaunchers.Sleeper;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.server.BrowserResponseSequencer;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RobotRetriever;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.SessionIdTracker;
import org.openqa.selenium.server.SpecialCommand;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.commands.AddCustomRequestHeaderCommand;
import org.openqa.selenium.server.commands.CaptureEntirePageScreenshotToStringCommand;
import org.openqa.selenium.server.commands.CaptureNetworkTrafficCommand;
import org.openqa.selenium.server.commands.CaptureScreenshotCommand;
import org.openqa.selenium.server.commands.CaptureScreenshotToStringCommand;
import org.openqa.selenium.server.commands.RetrieveLastRemoteControlLogsCommand;
import org.openqa.selenium.server.commands.SeleniumCoreCommand;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;

public class SeleniumDriverResourceHandler
extends ResourceHandler {
    static final Logger log = Logger.getLogger(SeleniumDriverResourceHandler.class.getName());
    static Log browserSideLog = LogFactory.getLog(String.valueOf(SeleniumDriverResourceHandler.class.getName()) + ".browserSideLog");
    private SeleniumServer remoteControl;
    private Map<String, String> domainsBySessionId = new HashMap<String, String>();
    private StringBuffer logMessagesBuffer = new StringBuffer();
    private BrowserLauncherFactory browserLauncherFactory;
    private final BrowserSessionFactory browserSessionFactory;

    public SeleniumDriverResourceHandler(SeleniumServer remoteControl, DriverSessions webdriverSessions) {
        this.browserLauncherFactory = new BrowserLauncherFactory(webdriverSessions);
        this.browserSessionFactory = new BrowserSessionFactory(this.browserLauncherFactory);
        this.remoteControl = remoteControl;
    }

    private String getParam(HttpRequest req, String name) {
        List parameterValues = req.getParameterValues(name);
        if (parameterValues == null) {
            return null;
        }
        return (String)parameterValues.get(0);
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
        PerSessionLogHandler perSessionLogHandler = LoggingManager.perSessionLogHandler();
        try {
            try {
                res.setField("Content-Type", "text/plain");
                this.setNoCacheHeaders(res);
                String method = req.getMethod();
                String cmd = this.getParam(req, "cmd");
                String sessionId = this.getParam(req, "sessionId");
                String seleniumStart = this.getParam(req, "seleniumStart");
                String loggingParam = this.getParam(req, "logging");
                String jsStateParam = this.getParam(req, "state");
                String retry = this.getParam(req, "retry");
                String closingParam = this.getParam(req, "closing");
                boolean logging = "true".equals(loggingParam);
                boolean jsState = "true".equals(jsStateParam);
                boolean justLoaded = "true".equals(seleniumStart);
                boolean retrying = "true".equals(retry);
                boolean closing = "true".equals(closingParam);
                if (sessionId != null) {
                    perSessionLogHandler.attachToCurrentThread(new SessionId(sessionId));
                }
                log.fine("req: " + req);
                if (cmd != null) {
                    this.handleCommandRequest(req, res, cmd, sessionId);
                } else if ("POST".equalsIgnoreCase(method) || justLoaded || logging) {
                    this.handleBrowserResponse(req, res, sessionId, logging, jsState, justLoaded, retrying, closing);
                } else if (-1 == req.getRequestURL().indexOf("selenium-server/core/scripts/user-extensions.js")) {
                    log.fine("Not handling: " + req.getRequestURL() + "?" + req.getQuery());
                    req.setHandled(false);
                }
            }
            catch (RuntimeException e) {
                String apparentFile;
                if (this.looksLikeBrowserLaunchFailedBecauseFileNotFound(e) && (apparentFile = this.extractNameOfFileThatCouldntBeFound(e)) != null) {
                    log.severe("Could not start browser; it appears that " + apparentFile + " is missing or inaccessible");
                }
                throw e;
            }
        }
        finally {
            perSessionLogHandler.detachFromCurrentThread();
        }
    }

    private void handleBrowserResponse(HttpRequest req, HttpResponse res, String sessionId, boolean logging, boolean jsState, boolean justLoaded, boolean retrying, boolean closing) throws IOException {
        List jsWindowNameVar;
        RemoteCommand sc;
        String seleniumWindowName = this.getParam(req, "seleniumWindowName");
        String localFrameAddress = this.getParam(req, "localFrameAddress");
        FrameAddress frameAddress = FrameGroupCommandQueueSet.makeFrameAddress(seleniumWindowName, localFrameAddress);
        String uniqueId = this.getParam(req, "uniqueId");
        String sequenceNumberString = this.getParam(req, "sequenceNumber");
        int sequenceNumber = -1;
        FrameGroupCommandQueueSet queueSet = FrameGroupCommandQueueSet.getQueueSet(sessionId);
        BrowserResponseSequencer browserResponseSequencer = queueSet.getCommandQueue(uniqueId).getBrowserResponseSequencer();
        if (sequenceNumberString != null && sequenceNumberString.length() > 0) {
            sequenceNumber = Integer.parseInt(sequenceNumberString);
            browserResponseSequencer.waitUntilNumIsAtLeast(sequenceNumber);
        }
        String postedData = this.readPostedData(req, sessionId, uniqueId);
        if (logging) {
            this.handleLogMessages(postedData);
        } else if (jsState) {
            this.handleJsState(sessionId, uniqueId, postedData);
        }
        if (postedData == null || postedData.equals("") || logging || jsState) {
            if (sequenceNumber != -1) {
                browserResponseSequencer.increaseNum();
            }
            res.getOutputStream().write("\r\n\r\n".getBytes());
            req.setHandled(true);
            return;
        }
        this.logPostedData(frameAddress, justLoaded, sessionId, postedData, uniqueId);
        if (retrying) {
            postedData = null;
        }
        if ((sc = queueSet.handleCommandResult(postedData, frameAddress, uniqueId, justLoaded, jsWindowNameVar = req.getParameterValues("jsWindowNameVar"))) != null) {
            this.respond(res, sc, uniqueId);
        }
        req.setHandled(true);
    }

    private void logPostedData(FrameAddress frameAddress, boolean justLoaded, String sessionId, String postedData, String uniqueId) {
        StringBuffer sb = new StringBuffer();
        sb.append("Browser " + sessionId + "/" + frameAddress + " " + uniqueId + " posted " + postedData);
        if (!frameAddress.isDefault()) {
            sb.append(" from " + frameAddress);
        }
        if (justLoaded) {
            sb.append(" NEW");
        }
        log.fine(sb.toString());
    }

    private void respond(HttpResponse res, RemoteCommand sc, String uniqueId) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
        if (sc != null) {
            writer.write(sc.toString());
            log.fine("res to " + uniqueId + ": " + sc.toString());
        } else {
            log.fine("res empty");
        }
        int pad = 998 - buf.size();
        while (pad-- > 0) {
            writer.write(" ");
        }
        writer.write("\r\n");
        ((Writer)writer).close();
        OutputStream out = res.getOutputStream();
        buf.writeTo(out);
    }

    private String readPostedData(HttpRequest req, String sessionId, String uniqueId) throws IOException {
        int c;
        if (req.getParameter("postedData") != null) {
            return req.getParameter("postedData");
        }
        InputStream is = req.getInputStream();
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((c = r.read()) != -1) {
            sb.append((char)c);
        }
        String postedData = sb.toString();
        if (postedData.startsWith("postedData=")) {
            postedData = postedData.substring(11);
            postedData = URLDecoder.decode(postedData, "UTF-8");
        }
        return postedData;
    }

    private void handleLogMessages(String s) {
        String[] lines;
        String[] stringArray = lines = s.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("logLevel=")) {
                int logLevelIdx = line.indexOf(58, "logLevel=".length());
                String logLevel = line.substring("logLevel=".length(), logLevelIdx).toUpperCase();
                String logMessage = line.substring(logLevelIdx + 1);
                if ("ERROR".equals(logLevel)) {
                    browserSideLog.error(logMessage);
                } else if ("WARN".equals(logLevel)) {
                    browserSideLog.warn(logMessage);
                } else if ("INFO".equals(logLevel)) {
                    browserSideLog.info(logMessage);
                } else {
                    browserSideLog.debug(logMessage);
                }
            }
            ++n2;
        }
    }

    private void handleJsState(String sessionId, String uniqueId, String s) {
        String jsInitializers = this.grepStringsStartingWith("state:", s);
        if (jsInitializers == null) {
            return;
        }
        String[] stringArray = jsInitializers.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String jsInitializer = stringArray[n2];
            String jsVarName = this.extractVarName(jsInitializer);
            InjectionHelper.saveJsStateInitializer(sessionId, uniqueId, jsVarName, jsInitializer);
            ++n2;
        }
    }

    private String extractVarName(String jsInitializer) {
        int x = jsInitializer.indexOf(61);
        if (x == -1) {
            x = jsInitializer.lastIndexOf(40);
            if (x == -1) {
                throw new RuntimeException("expected method call, saw " + jsInitializer);
            }
            if ((x = jsInitializer.lastIndexOf(46, x - 1)) == -1) {
                throw new RuntimeException("expected method call, saw " + jsInitializer);
            }
        }
        return jsInitializer.substring(0, x);
    }

    private String grepStringsStartingWith(String pattern, String s) {
        String[] lines = s.split("\n");
        StringBuffer sb = new StringBuffer();
        String retval = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(pattern)) {
                sb.append(line.substring(pattern.length())).append('\n');
            }
            ++n2;
        }
        if (sb.length() != 0) {
            retval = sb.toString();
        }
        return retval;
    }

    private String extractNameOfFileThatCouldntBeFound(Exception e) {
        String s = e.getMessage();
        if (s == null) {
            return null;
        }
        return s.replaceFirst(".*CreateProcess: ", "").replaceFirst(" .*", "");
    }

    private boolean looksLikeBrowserLaunchFailedBecauseFileNotFound(Exception e) {
        String s = e.getMessage();
        return s != null && s.matches("java.io.IOException: CreateProcess: .*error=3");
    }

    private void handleCommandRequest(HttpRequest req, HttpResponse res, String cmd, String sessionId) {
        res.setContentType("text/plain");
        this.hackRemoveConnectionCloseHeader(res);
        Vector<String> values = this.parseSeleneseParameters(req);
        String results = this.doCommand(cmd, values, sessionId, res);
        if (results != null) {
            try {
                res.getOutputStream().write(results.getBytes("UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        req.setHandled(true);
    }

    protected FrameGroupCommandQueueSet getQueueSet(String sessionId) {
        return FrameGroupCommandQueueSet.getQueueSet(sessionId);
    }

    public String doCommand(String cmd, Vector<String> values, String sessionId, HttpResponse res) {
        log.info("Command request: " + cmd + values.toString() + " on session " + sessionId);
        String results = null;
        switch (SpecialCommand.getValue(cmd)) {
            case getNewBrowserSession: {
                String browserString = values.get(0);
                String extensionJs = values.size() > 2 ? values.get(2) : "";
                String browserConfigurations = values.size() > 3 ? values.get(3) : "";
                try {
                    sessionId = this.getNewBrowserSession(browserString, values.get(1), extensionJs, BrowserOptions.newBrowserOptions(browserConfigurations));
                    LoggingManager.perSessionLogHandler().attachToCurrentThread(new SessionId(sessionId));
                    this.setDomain(sessionId, values.get(1));
                    results = "OK," + sessionId;
                }
                catch (RemoteCommandException rce) {
                    results = "Failed to start new browser session: " + rce;
                }
                catch (InvalidBrowserExecutableException ibex) {
                    results = "Failed to start new browser session: " + ibex;
                }
                catch (IllegalArgumentException iaex) {
                    results = "Failed to start new browser session: " + iaex;
                }
                catch (RuntimeException rte) {
                    results = "Failed to start new browser session: " + rte;
                }
                CaptureNetworkTrafficCommand.clear();
                break;
            }
            case testComplete: {
                this.browserSessionFactory.endBrowserSession(sessionId, this.remoteControl.getConfiguration());
                results = "OK";
                break;
            }
            case getLog: {
                try {
                    results = "OK," + LoggingManager.perSessionLogHandler().getLog(new SessionId(sessionId));
                }
                catch (IOException ioex) {
                    results = "Failed to get RC logs for the session: " + sessionId + " exception message: " + ioex.getMessage();
                }
                break;
            }
            case shutDownSeleniumServer: {
                results = "OK";
                this.shutDown(res);
                break;
            }
            case getLogMessages: {
                results = "OK," + this.logMessagesBuffer.toString();
                this.logMessagesBuffer.setLength(0);
                break;
            }
            case retrieveLastRemoteControlLogs: {
                results = new RetrieveLastRemoteControlLogsCommand().execute();
                break;
            }
            case captureEntirePageScreenshotToString: {
                results = new CaptureEntirePageScreenshotToStringCommand(values.get(0), sessionId).execute();
                break;
            }
            case captureScreenshot: {
                results = new CaptureScreenshotCommand(values.get(0)).execute();
                break;
            }
            case captureScreenshotToString: {
                results = new CaptureScreenshotToStringCommand().execute();
                break;
            }
            case captureNetworkTraffic: {
                results = new CaptureNetworkTrafficCommand(values.get(0)).execute();
                break;
            }
            case addCustomRequestHeader: {
                results = new AddCustomRequestHeaderCommand(values.get(0), values.get(1)).execute();
                break;
            }
            case keyDownNative: {
                try {
                    RobotRetriever.getRobot().keyPress(Integer.parseInt(values.get(0)));
                    results = "OK";
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Problem during keyDown: ", e);
                    results = "ERROR: Problem during keyDown: " + e.getMessage();
                }
                break;
            }
            case keyUpNative: {
                try {
                    RobotRetriever.getRobot().keyRelease(Integer.parseInt(values.get(0)));
                    results = "OK";
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Problem during keyUp: ", e);
                    results = "ERROR: Problem during keyUp: " + e.getMessage();
                }
                break;
            }
            case keyPressNative: {
                try {
                    Robot r = RobotRetriever.getRobot();
                    int keycode = Integer.parseInt(values.get(0));
                    r.keyPress(keycode);
                    r.waitForIdle();
                    r.keyRelease(keycode);
                    results = "OK";
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Problem during keyDown: ", e);
                    results = "ERROR: Problem during keyDown: " + e.getMessage();
                }
                break;
            }
            case isPostSupported: {
                results = "OK,true";
                break;
            }
            case setSpeed: {
                try {
                    int speed = Integer.parseInt(values.get(0));
                    SeleniumDriverResourceHandler.setSpeedForSession(sessionId, speed);
                }
                catch (NumberFormatException numberFormatException) {
                    return "ERROR: setSlowMode expects a string containing an integer, but saw '" + values.get(0) + "'";
                }
                results = "OK";
                break;
            }
            case getSpeed: {
                results = SeleniumDriverResourceHandler.getSpeedForSession(sessionId);
                break;
            }
            case addStaticContent: {
                File dir2 = new File(values.get(0));
                if (dir2.exists()) {
                    this.remoteControl.addNewStaticContent(dir2);
                    results = "OK";
                    break;
                }
                results = "ERROR: dir does not exist - " + dir2.getAbsolutePath();
                break;
            }
            case runHTMLSuite: {
                HTMLLauncher launcher = new HTMLLauncher(this.remoteControl);
                File output = null;
                if (values.size() < 4) {
                    results = "ERROR: Not enough arguments (browser, browserURL, suiteURL, multiWindow, [outputFile])";
                    break;
                }
                if (values.size() > 4) {
                    output = new File(values.get(4));
                }
                try {
                    results = launcher.runHTMLSuite(values.get(0), values.get(1), values.get(2), output, this.remoteControl.getConfiguration().getTimeoutInSeconds(), "true".equals(values.get(3)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    results = e.toString();
                }
                break;
            }
            case launchOnly: {
                if (values.size() < 1) {
                    results = "ERROR: You must specify a browser";
                    break;
                }
                String browser = values.get(0);
                String newSessionId = this.generateNewSessionId();
                BrowserLauncher simpleLauncher = this.browserLauncherFactory.getBrowserLauncher(browser, newSessionId, this.remoteControl.getConfiguration(), BrowserOptions.newBrowserOptions());
                String baseUrl = "http://localhost:" + this.remoteControl.getPort();
                this.remoteControl.registerBrowserSession(new BrowserSessionFactory.BrowserSessionInfo(newSessionId, browser, baseUrl, simpleLauncher, null));
                simpleLauncher.launchHTMLSuite("TestPrompt.html?thisIsSeleniumServer=true", baseUrl);
                results = "OK";
                break;
            }
            case slowResources: {
                String arg = values.get(0);
                boolean setting = true;
                if ("off".equals(arg) || "false".equals(arg)) {
                    setting = false;
                }
                StaticContentHandler.setSlowResources(setting);
                results = "OK";
                break;
            }
            case attachFile: {
                FrameGroupCommandQueueSet queue = this.getQueueSet(sessionId);
                try {
                    File downloadedFile = this.downloadFile(values.get(1));
                    queue.addTemporaryFile(downloadedFile);
                    results = queue.doCommand("type", values.get(0), downloadedFile.getAbsolutePath());
                }
                catch (Exception e) {
                    results = e.toString();
                }
                break;
            }
            case open: {
                this.warnIfApparentDomainChange(sessionId, values.get(0));
            }
            case nonSpecial: {
                results = new SeleniumCoreCommand(cmd, values, sessionId).execute();
            }
        }
        log.info(this.commandResultsLogMessage(cmd, sessionId, results));
        return results;
    }

    protected String commandResultsLogMessage(String cmd, String sessionId, String results) {
        if ("captureScreenshotToString".equals(cmd) || "captureEntirePageScreenshotToString".equals(cmd) || "captureEntirePageScreenshot".equals(cmd)) {
            return "Got result: [base64 encoded PNG] on session " + sessionId;
        }
        if ("getHtmlSource".equals(cmd)) {
            return "Got result: [HTML source] on session " + sessionId;
        }
        if ("retrieveLastRemoteControlLogs".equals(cmd)) {
            String trucatedResults = results.length() > 30 ? results.substring(0, 30) : results;
            return "Got result:" + trucatedResults + "... on session " + sessionId;
        }
        return "Got result: " + results + " on session " + sessionId;
    }

    private void warnIfApparentDomainChange(String sessionId, String url) {
        if (url.startsWith("http://")) {
            String urlDomain = url.replaceFirst("^(http://[^/]+, url)/.*", "$1");
            String domain = this.getDomain(sessionId);
            if (domain == null) {
                this.setDomain(sessionId, urlDomain);
            } else if (!url.startsWith(domain)) {
                log.warning("you appear to be changing domains from " + domain + " to " + urlDomain + "\n" + "this may lead to a 'Permission denied' from the browser (unless it is running as *iehta or *chrome,\n" + "or alternatively the selenium server is running in proxy injection mode)");
            }
        }
    }

    private String getDomain(String sessionId) {
        return this.domainsBySessionId.get(sessionId);
    }

    private Vector<String> parseSeleneseParameters(HttpRequest req) {
        Vector<String> values = new Vector<String>();
        int i = 1;
        while (req.getParameter(Integer.toString(i)) != null) {
            values.add(req.getParameter(Integer.toString(i)));
            ++i;
        }
        if (values.size() < 1) {
            values.add("");
        }
        if (values.size() < 2) {
            values.add("");
        }
        return values;
    }

    protected void download(URL url, File outputFile) {
        if (outputFile.exists()) {
            throw new RuntimeException("Output already exists: " + outputFile);
        }
        File directory = outputFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("Cannot directory for holding the downloaded file: " + outputFile);
        }
        try {
            FileOutputStream outputTo = new FileOutputStream(outputFile);
            Resources.copy(url, outputTo);
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate(e);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private void createParentDirsAndSetDeleteOnExit(String parent, File tmpFile) {
        File parentFile = tmpFile.getParentFile();
        if (!parentFile.getPath().equals(parent) && !parentFile.exists()) {
            this.createParentDirsAndSetDeleteOnExit(parent, parentFile);
        }
        parentFile.mkdir();
        parentFile.deleteOnExit();
    }

    protected File createTempFile(String name) {
        String parent = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(parent, name);
        if (tmpFile.exists()) {
            File tmpDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("selenium", "upload");
            tmpFile = new File(tmpDir, name);
        }
        this.createParentDirsAndSetDeleteOnExit(parent, tmpFile);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    private File downloadFile(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL <" + urlString + ">, ", e);
        }
        String fileName = url.getFile();
        File outputFile = this.createTempFile(fileName);
        this.download(url, outputFile);
        return outputFile;
    }

    protected static String getSpeedForSession(String sessionId) {
        FrameGroupCommandQueueSet queueSet;
        String results = null;
        if (sessionId != null && (queueSet = FrameGroupCommandQueueSet.getQueueSet(sessionId)) != null) {
            results = "OK," + queueSet.getSpeed();
        }
        if (results == null) {
            results = "OK," + CommandQueue.getSpeed();
        }
        return results;
    }

    protected static void setSpeedForSession(String sessionId, int speed) {
        if (sessionId != null) {
            FrameGroupCommandQueueSet queueSet = FrameGroupCommandQueueSet.getQueueSet(sessionId);
            if (speed < 0) {
                speed = 0;
            }
            if (queueSet != null) {
                queueSet.setSpeed(speed);
            }
        } else {
            CommandQueue.setSpeed(speed);
        }
    }

    private void shutDown(HttpResponse res) {
        log.info("Shutdown command received");
        Runnable initiateShutDown = new Runnable(){

            @Override
            public void run() {
                log.info("initiating shutdown");
                Sleeper.sleepTight(500L);
                System.exit(0);
            }
        };
        Thread isd = new Thread(initiateShutDown);
        isd.setName("initiateShutDown");
        isd.start();
        if (res != null) {
            try {
                res.getOutputStream().write("OK".getBytes());
                res.commit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String generateNewSessionId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    protected String getNewBrowserSession(String browserString, String startURL, String extensionJs, Capabilities browserConfigurations) throws RemoteCommandException {
        BrowserSessionFactory.BrowserSessionInfo sessionInfo = this.browserSessionFactory.getNewBrowserSession(browserString, startURL, extensionJs, browserConfigurations, this.remoteControl.getConfiguration());
        SessionIdTracker.setLastSessionId(sessionInfo.sessionId);
        return sessionInfo.sessionId;
    }

    private void hackRemoveConnectionCloseHeader(HttpResponse res) {
        res.removeField("Connection");
        Field[] fields = HttpConnection.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field _close;
            if (fields[i].getName().equals("_close")) {
                _close = fields[i];
                _close.setAccessible(true);
                try {
                    _close.setBoolean(res.getHttpConnection(), false);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (fields[i].getName().equals("_persistent")) {
                _close = fields[i];
                _close.setAccessible(true);
                try {
                    _close.setBoolean(res.getHttpConnection(), true);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void registerBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.browserSessionFactory.registerExternalSession(sessionInfo);
    }

    public void deregisterBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.browserSessionFactory.deregisterExternalSession(sessionInfo);
    }

    public void stopAllBrowsers() {
        this.browserSessionFactory.endAllBrowserSessions(this.remoteControl.getConfiguration());
    }

    private void setNoCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "no-cache");
        res.setField("Pragma", "no-cache");
        res.setField("Expires", HttpFields.__01Jan1970);
    }

    private void setDomain(String sessionId, String domain) {
        this.domainsBySessionId.put(sessionId, domain);
    }

    public BrowserLauncherFactory getBrowserLauncherFactory() {
        return this.browserLauncherFactory;
    }

    @Deprecated
    public void setBrowserLauncherFactory(BrowserLauncherFactory browserLauncherFactory) {
        this.browserLauncherFactory = browserLauncherFactory;
    }
}

