/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMAttribute;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNamedNodeMap;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNodeList;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClass=DomElement.class, browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLDOMElement
extends XMLDOMNode {
    private XMLDOMNamedNodeMap attributes_;
    private Map<String, XMLDOMNodeList> elementsByTagName_;

    @Override
    public Object getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    protected XMLDOMNamedNodeMap createAttributesObject() {
        return new XMLDOMNamedNodeMap(this.getDomNodeOrDie());
    }

    @Override
    public void setNodeValue(String newValue) {
        if (newValue == null || "null".equals(newValue)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        throw Context.reportRuntimeError("This operation cannot be performed with a node of type ELEMENT.");
    }

    @JsxGetter
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.toText(this.getDomNodeOrDie(), buffer);
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\n') {
            return buffer.substring(0, buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Override
    public void setText(Object value) {
        if (value == null || "null".equals(value)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        super.setText(value);
    }

    private void toText(DomNode node, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 10: 
            case 12: {
                return;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
        boolean lastWasElement = false;
        block8: for (DomNode child : node.getChildren()) {
            switch (child.getNodeType()) {
                case 1: {
                    lastWasElement = true;
                    this.toText(child, buffer);
                    continue block8;
                }
                case 3: 
                case 4: {
                    if (StringUtils.isBlank(child.getNodeValue())) {
                        if (lastWasElement) {
                            buffer.append(' ');
                        }
                        lastWasElement = false;
                        continue block8;
                    }
                    lastWasElement = false;
                    buffer.append(child.getNodeValue());
                    continue block8;
                }
            }
            lastWasElement = false;
        }
    }

    @JsxFunction
    public Object getAttribute(String name) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        if (StringUtils.isEmpty(name)) {
            throw Context.reportRuntimeError("The empty string '' is not a valid name.");
        }
        String value = this.getDomNodeOrDie().getAttribute(name);
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            return null;
        }
        return value;
    }

    @JsxFunction
    public Object getAttributeNode(String name) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        if (StringUtils.isEmpty(name)) {
            throw Context.reportRuntimeError("The empty string '' is not a valid name.");
        }
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptObject();
        }
        return null;
    }

    @JsxFunction
    public void removeAttribute(String name) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        if (StringUtils.isEmpty(name)) {
            throw Context.reportRuntimeError("The empty string '' is not a valid name.");
        }
        this.getDomNodeOrDie().removeAttribute(name);
        this.delete(name);
    }

    @JsxFunction
    public XMLDOMAttribute removeAttributeNode(XMLDOMAttribute att) {
        if (att == null || "null".equals(att)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        String name = att.getName();
        XMLDOMNamedNodeMap nodes = (XMLDOMNamedNodeMap)this.getAttributes();
        XMLDOMAttribute removedAtt = (XMLDOMAttribute)nodes.getNamedItemWithoutSyntheticClassAttr(name);
        if (removedAtt != null) {
            removedAtt.detachFromParent();
        }
        this.removeAttribute(name);
        return removedAtt;
    }

    @JsxFunction
    public void setAttribute(String name, String value) {
        if (name == null || "null".equals(name)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        if (StringUtils.isEmpty(name)) {
            throw Context.reportRuntimeError("The empty string '' is not a valid name.");
        }
        if (value == null || "null".equals(value)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    @JsxFunction
    public XMLDOMAttribute setAttributeNode(XMLDOMAttribute newAtt) {
        if (newAtt == null) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        String name = newAtt.getBaseName();
        XMLDOMNamedNodeMap nodes = (XMLDOMNamedNodeMap)this.getAttributes();
        XMLDOMAttribute replacedAtt = (XMLDOMAttribute)nodes.getNamedItemWithoutSyntheticClassAttr(name);
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        DomAttr newDomAttr = newAtt.getDomNodeOrDie();
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    @JsxFunction
    public XMLDOMNodeList getElementsByTagName(String tagName) {
        XMLDOMNodeList collection;
        if (tagName == null || "null".equals(tagName)) {
            throw Context.reportRuntimeError("Type mismatch.");
        }
        final String tagNameTrimmed = tagName.trim();
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, XMLDOMNodeList>();
        }
        if ((collection = this.elementsByTagName_.get(tagNameTrimmed)) != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        String description = "XMLDOMElement.getElementsByTagName('" + tagNameTrimmed + "')";
        collection = "*".equals(tagNameTrimmed) ? new XMLDOMNodeList(node, false, description){

            @Override
            protected boolean isMatching(DomNode node) {
                return true;
            }
        } : ("".equals(tagNameTrimmed) ? new XMLDOMNodeList(node, false, description){

            @Override
            protected List<Object> computeElements() {
                ArrayList<Object> response = new ArrayList<Object>();
                Object domNode = this.getDomNodeOrNull();
                if (domNode == null) {
                    return response;
                }
                for (DomNode node : this.getCandidates()) {
                    if (node instanceof DomText) {
                        DomText domText = (DomText)node;
                        if (StringUtils.isBlank(domText.getWholeText())) continue;
                        response.add(node);
                        continue;
                    }
                    response.add(node);
                }
                return response;
            }
        } : new XMLDOMNodeList(node, false, description){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagNameTrimmed.equals(node.getNodeName());
            }
        });
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    @JsxFunction
    public void normalize() {
        DomElement domElement = this.getDomNodeOrDie();
        domElement.normalize();
        this.normalize(domElement);
    }

    private void normalize(DomElement domElement) {
        for (DomNode domNode : domElement.getChildren()) {
            if (!(domNode instanceof DomElement)) continue;
            domNode.normalize();
            this.normalize((DomElement)domNode);
        }
    }

    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }
}

