#!/usr/bin/python
# -*- coding: utf-8 -*-

##
# Windows installer helper for CIRCLE client application
##

import os, sys, argparse
import pythoncom
from win32com.shell import shell, shellcon

##
# Argument parser, argparse modulon alapszik
# @return args
#
def pars_arguments():
    parser = argparse.ArgumentParser();
    parser.add_argument("-d", "--driver", help="Select webdriver. Aside from Firefox, you have to install first the proper driver.", \
        type=str, choices=['firefox', 'chrome', 'iexplore', 'opera'], default="firefox")
    parser.add_argument("-l", "--location", help="Location of the client files in the system", default=os.getenv('ProgramFiles')+"\\CIRCLE\\")
    args = parser.parse_args();
    return args

##
# Main program
#   read the parameters
#   create a proper icon with the proper driver
def main():
    try:
        args = pars_arguments()
        shortcut = pythoncom.CoCreateInstance (
          shell.CLSID_ShellLink,
          None,
          pythoncom.CLSCTX_INPROC_SERVER,
          shell.IID_IShellLink
        )
        shortcut.SetPath (args.location+"cloud.py")
        if args.driver == "chrome":
            shortcut.SetArguments("-d chrome")
        elif args.driver == "iexplore":
            shortcut.SetArguments("-d ie")
        elif args.driver == "opera":
            shortcut.SetArguments("-d opera")
        shortcut.SetDescription ("Tool to use CIRCLE Cloud")
        shortcut.SetIconLocation (args.location+"cloud.ico", 0)

        desktop_path = shell.SHGetFolderPath (0, shellcon.CSIDL_DESKTOP, 0, 0)
        persist_file = shortcut.QueryInterface (pythoncom.IID_IPersistFile)
        persist_file.Save (os.path.join (desktop_path, "Cloud GUI.lnk"), 0)
    except:
        pass
if __name__ == "__main__":
    main()