#!/usr/bin/python
# -*- coding: utf-8 -*-

##
# A cloudban létrehozott virtuális gépekhez történő kapcsolódást segítő program
##

from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
import platform, argparse, sys, time

##
# Paraméterek átadására használt struktúra
# state     A virtuális gép állapota, azt figyeljük, hogy fut-e
# protocol  SSH, NX és RDP lehetséges
# host      A virtuális gép címe
# port      Ezen a porton csatlakozunk a virtuális géphez
# user      Csatlakozáshoz használt név
# password  Csatlakozáshoz használt jelszó

class Struct:
    pass

##
# Argument parser, argparse modulon alapszik
# @return args
#

def pars_arguments():
    parser = argparse.ArgumentParser();
    parser.add_argument("uri", type=str, help="Specific schema handler", nargs='?', default=None)
    parser.add_argument("-u", "--username", type=str)
    parser.add_argument("-p", "--password", type=str)
    parser.add_argument("-d", "--driver", help="Select webdriver. Aside from Firefox, you have to install first the proper driver.", \
        type=str, choices=['firefox', 'chrome', 'ie', 'opera'], default="firefox")
    parser.add_argument("-o", "--old", help="Use old interface", action="store_true")
    args = parser.parse_args();
    return args

class Browser:
    ##
    # Browser inicializálás
    # @param args Az args.driver paraméterrel meghatározhatjuk, melyik böngészőt akarjuk használni.
    #
    def __init__(self, args):
        self.args = args
        if args.driver == "firefox":
            self.driver = webdriver.Firefox()
        elif args.driver == "chrome":
            self.driver = webdriver.Chrome()
        elif args.driver == "ie":
            self.driver = webdriver.Ie()
        elif args.driver == "opera":
            self.driver = webdriver.Opera()
        self.driver.implicitly_wait(10)

    ##
    # Címtáras beléptetés a parancssorban megadott paraméterek alapján
    #
    def login(self):
        driver = self.driver
        args = self.args
        if args.username is not None:
            driver.find_element_by_name("j_username").clear()
            driver.find_element_by_name("j_username").send_keys(args.username)
        if args.password is not None:
            driver.find_element_by_name("j_password").clear()
            driver.find_element_by_name("j_password").send_keys(args.password)
        if args.username is not None and args.password is not None:
            driver.find_element_by_css_selector("input[type='submit']").click()

    ##
    # A régi webes felület használata
    # @return vm    Virtuális gép csatlakozásához szükséges paraméterek
    #
    def old_main(self):
        vm = Struct()
        driver = self.driver
        driver.maximize_window()
        driver.get("https://cloud.ik.bme.hu/info/")
        driver.find_element_by_css_selector("a[href*='/login/']").click()
        self.login()
        vm.state, vm.protocol = "", "NONE"
        try:
            while vm.state.upper()[:3] not in ("FUT", "RUN"):
                element = WebDriverWait(driver, 7200).until(EC.presence_of_element_located((By.CSS_SELECTOR, "input.hidden-password.shown[type='text']")))
                vm.password = element.get_attribute("value")
                vm.state = driver.find_element_by_css_selector("#state > div > p").text
            vm.protocol = driver.find_element_by_css_selector("#vm-credentials > div > table > tbody > tr:nth-child(1) > td").text
            vm.host,vm.port = driver.find_element_by_css_selector("#vm-credentials > div > table > tbody > tr:nth-child(2) > td").text.split(':')
            vm.user = driver.find_element_by_css_selector("#vm-credentials > div > table > tbody > tr:nth-child(4) > td").text
            driver.find_element_by_css_selector("a[href*='/logout/']").click()
        except:
            print "Browser session timed out!"
            raise
        return vm

    ##
    # Az új webes felület használata
    # @return vm    Virtuális gép csatlakozásához szükséges paraméterek
    #
    def main(self):
        vm = Struct()
        driver = self.driver
        driver.maximize_window()
        driver.get("https://pc3.szgt.uni-miskolc.hu/")
        #driver.find_element_by_css_selector("a[href*='/login/']").click()
        #self.login()
        vm.state, vm.protocol = "", "NONE"
        try:
            while vm.state.upper()[:3] not in ("FUT", "RUN"):
                element = WebDriverWait(driver,7200).until(EC.presence_of_element_located((By.CSS_SELECTOR, "#vm-details-pw-eye.icon-eye-close")))
                vm.state = driver.find_element_by_css_selector("#vm-details-state > span").text
            #cl: connection string converted to list
            cl = driver.find_element_by_css_selector("#vm-details-connection-string").get_attribute("value").split()
            if cl[0] == "sshpass":
                vm.protocol = "SSH"
                vm.user, vm.host = cl[6].split("@")
                vm.password, vm.port = cl[2], cl[8]
            elif cl[0] == "rdesktop":
                vm.protocol = "RDP"
                vm.host, vm.port = cl[1].split(":")
                vm.user, vm.password = cl[3], cl[5]
            driver.find_element_by_css_selector("a[href*='/logout/']").click()
        except:
            print "Browser session timed out!"
            raise
        return vm

##
# Főprogram
#   beolvassuk a paramétereket
#   megnyitjuk a kiválasztott böngészőben a weboldalt
#   bejelentkezünk a címtárba
#   kiválasztjuk a futtatni kívánt klienst
#   kapcsolódunk a klienshez

def main():
    try:
        args = pars_arguments()
        if args.uri is not None:
            vm = Struct()
            vm.protocol, vm.user, vm.password, vm.host, vm.port = args.uri.split(':',4)
            vm.protocol = vm.protocol.upper()
            vm.state = "RUN"
        else: 
            browser = Browser(args)
            try:
                if args.old:
                    vm = browser.old_main()
                else:
                    vm = browser.main()
                browser.driver.quit()
            except:
                raise
        if platform.system() == "Linux":
            from cloud_connect_from_linux import connect
        elif platform.system() == "Windows":
            from cloud_connect_from_windows import connect
        if vm.state.upper()[:3] in ("FUT", "RUN"):
            connect(vm)
    except:
        pass
if __name__ == "__main__":
    main()
