/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.html5;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.html5.Utils;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;
import org.openqa.selenium.remote.server.handler.internal.ResultConverter;

public class ExecuteSQL
extends WebDriverHandler<Object>
implements JsonParametersAware {
    private String dbName;
    private String query;
    private List<Object> args = Lists.newArrayList();

    public ExecuteSQL(Session session) {
        super(session);
    }

    @Override
    public Object call() throws Exception {
        ResultSet value = Utils.getDatabaseStorage(this.getUnwrappedDriver()).executeSQL(this.dbName, this.query, this.args.toArray());
        return new ResultConverter(this.getKnownElements()).apply(value);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.dbName = (String)allParameters.get("dbName");
        this.query = (String)allParameters.get("query");
        List params = (List)allParameters.get("args");
        this.args = Lists.newArrayList(Iterables.transform(params, new ArgumentConverter(this.getKnownElements())));
    }

    public String toString() {
        return String.format("[execute SQL query: %s, %s, %s]", this.dbName, this.query, this.args);
    }
}

