/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;

class ChromeCommandExecutor
extends HttpCommandExecutor {
    private final ChromeDriverService service;

    public ChromeCommandExecutor(ChromeDriverService service) {
        super(service.getUrl());
        this.service = service;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            this.service.start();
        }
        try {
            Response response = super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause(t);
            if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage()) && !this.service.isRunning()) {
                throw new WebDriverException("The chromedriver server has unexpectedly died!", t);
            }
            Throwables.propagateIfPossible(t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.service.stop();
            }
        }
    }
}

